package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectTemplatePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectTemplateQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateVO;

import java.util.List;

/**
 * 项目模板
 *
 * @author xxb
 * @date 2023-08-02
 */
public interface PmsProjectTemplateService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectTemplateVO}>
     */
    PagingVO<PmsProjectTemplateVO> paging(PmsProjectTemplateQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectTemplateVO}>
     */
    List<PmsProjectTemplateVO> queryListDynamic(PmsProjectTemplateQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectTemplateVO}
     */
    PmsProjectTemplateVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsProjectTemplateVO}
     */
    PmsProjectTemplateVO insert(PmsProjectTemplatePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectTemplateVO}
     */
    PmsProjectTemplateVO update(PmsProjectTemplatePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 修改状态
     *
     * @param ids 单据数据
     * @return {@link }
     */
    Long updateStatus(List<Long> ids,Integer templateStatus);
}
