package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 部门毛利率配置
 *
 * @author wangly
 * @date 2024-04-01
 */
@Getter
@Setter
public class OrgGrossProfitRateSettingQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 部门id 精确
     */
    @ApiModelProperty("部门id")
    private Long orgId;
    /**
     * 部门id集合 精确
     */
    @ApiModelProperty("部门id集合")
    private List<Long> orgIdList;

    /**
     * 工作类型 [salecon:work_type] 精确
     */
    @ApiModelProperty("工作类型 [salecon:work_type]")
    private String workType;
    /**
     * 部门毛利率 精确
     */
    @ApiModelProperty("部门毛利率")
    private BigDecimal orgGrossProfitRate;
    /**
     * 过单毛利率 精确
     */
    @ApiModelProperty("过单毛利率")
    private BigDecimal orderGrossProfitRate;
    /**
     * 开始日期 精确
     */
    @ApiModelProperty("开始日期")
    private LocalDate startDate;
    /**
     * 结束日期 精确
     */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /**
     * 排序号 精确
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /**
     * 拓展字段1 精确
     */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /**
     * 拓展字段2 精确
     */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /**
     * 拓展字段3 精确
     */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /**
     * 拓展字段4 精确
     */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /**
     * 拓展字段5 精确
     */
    @ApiModelProperty("拓展字段5")
    private String ext5;

    /**
     * 排除id
     */
    @ApiModelProperty("排除id")
    private List<Long> notInIds;


    /**
     * 资源经理
     */
    @ApiModelProperty("资源经理")
    private Long resManagerId;
}
