package com.elitesland.tw.tw5.api.prd.system.payload;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * 公共地点表
 *
 * @author zoey
 * @date 2024-04-22
 */
@Getter
@Setter
public class PrdSystemSitePayload extends TwCommonPayload  implements Serializable {
    /** 地点名称 */
    @ApiModelProperty("地点名称")
    private String siteDesc;
    /** 经度 */
    @ApiModelProperty("经度")
    private String siteLongitude;
    /** 纬度 */
    @ApiModelProperty("纬度")
    private String siteLatitude;
    /** 单据ID */
    @ApiModelProperty("单据ID")
    private Long docId;
    /** 单据类型 */
    @ApiModelProperty("单据类型")
    private String docType;
    /** 地点ID */
    @Comment("地点ID")
    @Column()
    private Long siteId;
    /** 关系表ID */
    @Comment("关系表ID")
    @Column()
    private Long refId;
}
