package com.elitesland.tw.tw5.api.prd.ts.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsNotaskApprovalConfigRulePayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigRuleQuery;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigRuleVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * notask_approval_1
 *
 * @author zoey
 * @date 2024-04-30
 */
public interface TsNotaskApprovalConfigRuleService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TsNotaskApprovalConfigRuleVO}>
     */
    PagingVO<TsNotaskApprovalConfigRuleVO> queryPaging(TsNotaskApprovalConfigRuleQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TsNotaskApprovalConfigRuleVO}>
     */
    List<TsNotaskApprovalConfigRuleVO> queryListDynamic(TsNotaskApprovalConfigRuleQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TsNotaskApprovalConfigRuleVO}
     */
    TsNotaskApprovalConfigRuleVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TsNotaskApprovalConfigRuleVO}
     */
    TsNotaskApprovalConfigRuleVO insert(TsNotaskApprovalConfigRulePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TsNotaskApprovalConfigRuleVO}
     */
    TsNotaskApprovalConfigRuleVO update(TsNotaskApprovalConfigRulePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TsNotaskApprovalConfigRulePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 逻辑删除
     * @param configIds
     */
    void deleteSoftByConfigId(List<Long> configIds);

    /**
     * 查询配置下的规则列表
     * @param key
     * @return
     */
    List<TsNotaskApprovalConfigRuleVO> queryByConfigId(Long key);
}
