package com.elitesland.tw.tw5.api.prd.visit.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 销售拜访任务管理
 *
 * @author duwh
 * @date 2023-03-13
 */
@Getter
@Setter
public class VisitTaskQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;
    /**
     * 拜访计划主键 精确
     */
    @ApiModelProperty("拜访计划主键")
    @Query
    private Long planId;
    /**
     * 任务名称 模糊
     */
    @ApiModelProperty("任务名称")
    @Query(type = Query.Type.INNER_LIKE)
    private String taskName;
    /**
     * 任务编号 模糊
     */
    @ApiModelProperty("任务编号")
    @Query(type = Query.Type.INNER_LIKE)
    private String taskNo;
    /**
     * 拜访计划名称（冗余） 模糊
     */
    @ApiModelProperty("拜访计划名称（冗余）")
    @Query(type = Query.Type.INNER_LIKE)
    private String planName;
    /**
     * 拜访计划类型（冗余） 精确
     */
    @ApiModelProperty("拜访计划类型（冗余）")
    @Query
    private String planType;
    /**
     * 拜访客户主键 crm_customer.id 精确 see partnerId
     */
    @ApiModelProperty("拜访客户主键 crm_customer.id see partnerId")
    @Query
    @Deprecated
    private Long customerId;
    /**
     * 业务伙伴主键（客户主表） business_partner.id
     */
    @ApiModelProperty("业务伙伴主键（客户主表） business_partner.id")
    private Long partnerId;
    /**
     * 拜访客户名称（冗余）crm_customer.customer_name 模糊
     */
    @ApiModelProperty("拜访客户名称（冗余）crm_customer.customer_name")
    @Query(type = Query.Type.INNER_LIKE)
    private String customerName;
    /**
     * 任务状态 udc[crm:visit:task_status](已完成OK、待提交READY、未开始NEW) 精确
     */
    @ApiModelProperty("任务状态 udc[crm:visit:task_status](已完成OK、待提交READY、未开始NEW)")
    @Query
    private String status;
    @ApiModelProperty("任务状态集合 udc[crm:visit:task_status](已完成OK、待提交READY、未开始NEW)")
    @Query(type = Query.Type.IN, propName = "status")
    private Collection<String> statusList;
    @ApiModelProperty("任务状态数组 udc[crm:visit:task_status](已完成OK、待提交READY、未开始NEW)")
    private String[] statusArr;

    public Collection<String> getStatusList() {
        if (CollectionUtils.isEmpty(statusList)) {
            if (statusArr != null && statusArr.length > 0) {
                return Arrays.asList(statusArr);
            }
        }
        return statusList;
    }

    /**
     * 拜访成员 精确
     */
    @ApiModelProperty("拜访成员")
    @Query
    private Long visitMemberId;
    /**
     * 拜访成员id集合 移动端销售统计数据查询 2023/06/14 精确
     */
    @ApiModelProperty("拜访成员id集合")
    @Query
    private List<Long> visitMemberIds;
    /**
     * 拜访成员 直属上级
     */
    @ApiModelProperty("拜访成员 直属上级")
    @Query
    private Long visitMemberParentId;
    /**
     * 拜访成员姓名 模糊
     */
    @ApiModelProperty("拜访成员姓名")
    @Query(type = Query.Type.INNER_LIKE)
    private String visitMemberName;
    /**
     * 协防人员 多个英文逗号隔开 模糊
     */
    @ApiModelProperty("协防人员 多个英文逗号隔开")
    @Query(type = Query.Type.INNER_LIKE)
    private String teamMemberIds;
    /**
     * 关联信息类型（线索、商机OPPO、经营计划、销售目标） 精确
     */
    @ApiModelProperty("关联信息类型（线索、商机OPPO、经营计划、销售目标）")
    @Query
    private String objType;
    /**
     * 关联信息主键（关联主键) 精确
     */
    @ApiModelProperty("关联信息主键（关联主键)")
    @Query
    private Long objId;
    /**
     * 关联信息名称（冗余） 模糊
     */
    @ApiModelProperty("关联信息名称（冗余）")
    @Query(type = Query.Type.INNER_LIKE)
    private String objName;
    /**
     * 计划创建人 精确
     */
    @ApiModelProperty("计划创建人")
    @Query
    private Long planCreateUserId;
    /**
     * 评价状态 NEW待评价 OK已评价 精确
     */
    @ApiModelProperty("评价状态 NEW待评价 OK已评价")
    @Query
    private String evalStatus;
    /**
     * 查询为空 or  待评价数据
     */
    @ApiModelProperty(" 查询为空 or  待评价数据 ")
    @Query
    private String evalStatusPro;
    /**
     * 领导评分 精确
     */
    @ApiModelProperty("领导评分")
    @Query
    private Integer leaderGradle;
    /**
     * 下次拜访行动部署 模糊
     */
    @ApiModelProperty("下次拜访行动部署")
    @Query(type = Query.Type.INNER_LIKE)
    private String nextPlan;
    /**
     * 客户评分 精确
     */
    @ApiModelProperty("客户评分")
    @Query
    private Integer customerGradle;
    /**
     * 客户建议 模糊
     */
    @ApiModelProperty("客户建议")
    @Query(type = Query.Type.INNER_LIKE)
    private String customerAdvise;

    /**
     * 经度和纬度用","分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标。 精确
     */
    @ApiModelProperty("经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标。")
    @Query
    private String customerLocations;
    /**
     * 是否打卡范围，0：否，1：是 精确
     */
    @ApiModelProperty("是否打卡范围，0：否，1：是")
    @Query
    private Integer signRangeFlag;
    /**
     * 附件（录音）多个文件，英文逗号分隔 模糊
     */
    @ApiModelProperty("附件（录音）多个文件，英文逗号分隔")
    @Query(type = Query.Type.INNER_LIKE)
    private String fileCodes;
    /**
     * 客户情况说明 模糊
     */
    @ApiModelProperty("客户情况说明")
    @Query(type = Query.Type.INNER_LIKE)
    private String customerDesc;
    /**
     * 拜访进展与结果 模糊
     */
    @ApiModelProperty("拜访进展与结果")
    @Query(type = Query.Type.INNER_LIKE)
    private String result;

    /**
     * 客户意愿 udc[crm:follow:cust_aspiration]
     */
    @ApiModelProperty("客户意愿 udc[crm:follow:cust_aspiration]")
    @Query
    private String customerWillingness;
    /**
     * 重大销售线索
     */
    @ApiModelProperty("重大销售线索")
    @Query(type = Query.Type.INNER_LIKE)
    private String leads;
    /**
     * 市场感知反馈
     */
    @ApiModelProperty("市场感知反馈")
    @Query(type = Query.Type.INNER_LIKE)
    private String marketFeedback;
    /**
     * 产品反馈
     */
    @ApiModelProperty("产品反馈")
    @Query(type = Query.Type.INNER_LIKE)
    private String productFeedback;
    /**
     * 活动参与反馈
     */
    @ApiModelProperty("活动参与反馈")
    @Query(type = Query.Type.INNER_LIKE)
    private String activityFeedback;
    /**
     * 其他需求反馈
     */
    @ApiModelProperty("其他需求反馈")
    @Query(type = Query.Type.INNER_LIKE)
    private String otherFeedback;


    /**
     * 签到坐标（最新） 模糊
     */
    @ApiModelProperty("签到坐标（最新）")
    @Query(type = Query.Type.INNER_LIKE)
    private String signLocations;
    /**
     * 签到地点（最新） 模糊
     */
    @ApiModelProperty("签到地点（最新）")
    @Query(type = Query.Type.INNER_LIKE)
    private String signAddress;
    /**
     * 签到图片（最新） 模糊
     */
    @ApiModelProperty("签到图片（最新）")
    @Query(type = Query.Type.INNER_LIKE)
    private String signFileCodes;
    /**
     * 签退坐标（最新） 模糊
     */
    @ApiModelProperty("签退坐标（最新）")
    @Query(type = Query.Type.INNER_LIKE)
    private String signOutLocations;
    /**
     * 签退地点（最新） 模糊
     */
    @ApiModelProperty("签退地点（最新）")
    @Query(type = Query.Type.INNER_LIKE)
    private String signOutAddress;
    /**
     * 签退图片（最新） 模糊
     */
    @ApiModelProperty("签退图片（最新）")
    @Query(type = Query.Type.INNER_LIKE)
    private String signOutFileCodes;

    /**
     * 拓展字段1 精确
     */
    @ApiModelProperty("拓展字段1")
    @Query
    private String ext1;
    /**
     * 拓展字段2 精确
     */
    @ApiModelProperty("拓展字段2")
    @Query
    private String ext2;
    /**
     * 拓展字段3 精确
     */
    @ApiModelProperty("拓展字段3")
    @Query
    private String ext3;
    /**
     * 拓展字段4 精确
     */
    @ApiModelProperty("拓展字段4")
    @Query
    private String ext4;
    /**
     * 拓展字段5 精确
     */
    @ApiModelProperty("拓展字段5")
    @Query
    private String ext5;
    /**
     * 排序号 精确
     */
    @ApiModelProperty("排序号")
    @Query
    private Integer sortNo;

    @ApiModelProperty("拜访时间筛选")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate visitTime;

    /**
     * 拜访开始时间 大于等于
     */
    @ApiModelProperty("拜访开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startTime;
    /**
     * 拜访结束时间 小于等于
     */
    @ApiModelProperty("拜访结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endTime;

    /**
     * 销售拜访计划 提醒时间 添加提醒
     */
    @ApiModelProperty("添加提醒")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime remindTime;

    /**
     * 创建用户id查询
     */
    private Long createUserIdPro;

    /**
     * 需要权限
     */
    private Boolean permissionFlag = false;
    /**
     * 下属 下属的下属集合
     */
    private Set<Long> subordinatesIds;

    /**
     * 下属id集合 查评价
     */
    private Set<Long> evalSubordinatesIds;

    /**
     * 拜访任务类型 udc[crm:visit:task_type]
     */
    @ApiModelProperty("拜访任务类型")
    private String taskType;
    /**
     * 销售资源id集合
     */
    private List<Long> SaleUserIds;
    /**
     * 当前登录人
     */
    private Long loginUserId;
}
