package com.elitesland.tw.tw5.api.prd.visit.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerForVisitTaskPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitTaskOpenPayload;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitTaskPayload;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitTaskVO;


import java.util.List;

/**
 * 销售拜访任务管理
 *
 * @author duwh
 * @date 2023-03-13
 */
public interface VisitTaskService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link VisitTaskVO}>
     */
    PagingVO<VisitTaskVO> paging(VisitTaskQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link VisitTaskVO}>
     */
    PagingVO<VisitTaskVO> queryPaging(VisitTaskQuery query);

    /**
     * 我的拜访任务-分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link VisitTaskVO}>
     */
    PagingVO<VisitTaskVO> myQueryPaging(VisitTaskQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link VisitTaskVO}>
     */
    List<VisitTaskVO> queryListDynamic(VisitTaskQuery query);

    /**
     * 我的任务查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link VisitTaskVO}>
     */
    List<VisitTaskVO> queryListDynamicWithoutPermission(VisitTaskQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link VisitTaskVO}
     */
    VisitTaskVO queryByKey(Long key);

    /**
    * 新增
    *
    * @param payload 单据数据
    * @return {@link VisitTaskVO}
    */
    VisitTaskVO insert(VisitTaskPayload payload);

    /**
    * 修改
    *
    * @param payload 单据数据
    * @return {@link VisitTaskVO}
    */
    VisitTaskVO update(VisitTaskPayload payload);

    /**
     * 根据拜访计划生成任务
     *
     * @param planId 计划id
     * @return {@link List}<{@link VisitTaskVO}>
     */
    List<VisitTaskVO> generateTaskByPlanId(Long planId);

    /**
    * 逻辑删除
    *
    * @param keys 主键集合
    */
    void deleteSoft(List<Long> keys);

    /**
     * 根据计划删除软id
     *
     * @param planId 计划id
     */
    void deleteSoftByPlanId(Long planId);

    /**
     * 统计任务数量 ：拜访计划下 任务状态为【已完成、待提交】的数据
     *
     * @param planId 计划id
     * @return long
     */
    long countByPlanId(Long planId);

    /**
     * 客户评价
     *
     * @param payload 有效载荷
     * @return {@link VisitTaskOpenPayload}
     */
    VisitTaskOpenPayload customerEval(VisitTaskOpenPayload payload);

    /**
     * 领导评价
     *
     * @param payload 有效载荷
     * @return {@link VisitTaskPayload}
     */
    VisitTaskVO leaderEval(VisitTaskPayload payload);

    /**
     * 统计
     *
     * @param query 查询
     * @return long
     */
    long count(VisitTaskQuery query);

    /**
     * 业务伙伴管理-新增
     *
     * @param payload 有效载荷
     * @return {@link BusinessPartnerVO}
     */
    BusinessPartnerVO businessPartnerInsert(BusinessPartnerForVisitTaskPayload payload);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link VisitTaskVO}
     */
    VisitTaskVO insertTask(VisitTaskPayload payload);
}
