package com.elitesland.tw.tw5.api.common.funConfig.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.util.List;

/**
 * 通用文档配置 业务类型访问权限
 *
 * @author duwh
 * @date 2023-12-11
 */
@Getter
@Setter
public class BusinessDocTypeConfigRoleRefQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 文档类型配置 单据类型 精确 */
    @ApiModelProperty("文档类型配置 单据类型")
    private String docType;
    /** 角色编码 精确 */
    @ApiModelProperty("角色编码")
    private String roleCode;
    /** 角色编码 精确 */
    @ApiModelProperty("角色编码集合")
    private List<String> roleCodeList;
    /** 角色名称 精确 */
    @ApiModelProperty("角色名称")
    private String roleName;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
}
