package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 费用报销税额管理
 *
 * @author sunxw
 * @date 2023-12-05
 */
@Getter
@Setter
public class AccReimTaxQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("id集合")
    private List<Long> ids;

    /**
     * 报销单ID 精确
     */
    @ApiModelProperty("报销单ID")
    private Long reimId;
    /**
     * 报销单明细ID 精确
     */
    @ApiModelProperty("报销单明细ID")
    private Long reimDtlId;
    /**
     * 会计科目 精确
     */
    @ApiModelProperty("会计科目")
    private Long finAccSubjId;
    /**
     * 税率 精确
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 税额 精确
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("报销单ID集合")
    private List<Long> reimIdList;

    @ApiModelProperty("报销单号")
    private String reimNo;

    @ApiModelProperty("报销人USER_ID")
    private Long reimUserId;

    @ApiModelProperty("单据类型")
    private String reimDocType;

    @ApiModelProperty("报销类型")
    private String reimType;

    /**
     * 记账时间起止
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime accountingDateStart;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime accountingDateEnd;

    @ApiModelProperty("记账批次号")
    private String batchNo;

    @ApiModelProperty()
    private Long expenseCompany;

}
