package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimBusItemConfigPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimBusItemConfigQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimBusItemConfigVO;

import java.util.List;

/**
 * 报销科目配置管理
 *
 * @author sunxw
 * @date 2023-12-15
 */
public interface AccReimBusItemConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimBusItemConfigVO}>
     */
    PagingVO<AccReimBusItemConfigVO> queryPaging(AccReimBusItemConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimBusItemConfigVO}>
     */
    List<AccReimBusItemConfigVO> queryListDynamic(AccReimBusItemConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimBusItemConfigVO}
     */
    AccReimBusItemConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimBusItemConfigVO}
     */
    AccReimBusItemConfigVO insert(AccReimBusItemConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimBusItemConfigVO}
     */
    AccReimBusItemConfigVO update(AccReimBusItemConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    void updateByKeyDynamic(AccReimBusItemConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
