package com.elitesland.tw.tw5.api.prd.adm.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * 特殊费用申请管理
 *
 * @author carl
 * @date 2023-11-01
 */
@Getter
@Setter
public class AdmFeeApplyVO extends BaseViewModel implements Serializable {
    /**
     * 申请单号
     */
    @ApiModelProperty("申请单号")
    private String applyNo;
    /**
     * 申请单名称
     */
    @ApiModelProperty("申请单名称")
    private String applyName;
    /**
     * 申请状态
     */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    @UdcName(udcName = "ADM:COST:APPLY:STATUS", codePropName = "applyStatus")
    private String applyStatusDesc;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例id
     */
    @ApiModelProperty("流程实例id")
    private String procInstId;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 财务期间id
     */
    @ApiModelProperty("财务期间id")
    private Long finPeriodId;
    /**
     * 用途类型
     */
    @ApiModelProperty("用途类型")
    private String usageType;
    @UdcName(udcName = "ADM:COST:USE_TYPE", codePropName = "usageType")
    private String usageTypeDesc;
    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    private String reasonTypeDesc;
    /**
     * 事由id
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 事由名称
     */
    @ApiModelProperty("事由名称")
    private String reasonName;
    /**
     * 费用承担bu_id
     */
    @ApiModelProperty("费用承担bu_id")
    private Long expenseBuId;
    @UdcName(udcName = "BU", codePropName = "expenseBuId")
    private String expenseBuName;
    /**
     * 费用归属bu_id
     */
    @ApiModelProperty("费用归属bu_id")
    private Long sumBuId;
    @UdcName(udcName = "BU", codePropName = "sumBuId")
    private String sumBuName;

    /**
     * 申请人资源id
     */
    @ApiModelProperty("申请人资源id")
    private Long applyResId;
    @UdcName(udcName = "USER", codePropName = "applyResId")
    private String applyResName;
    /**
     * 申请人bu_id
     */
    @ApiModelProperty("申请人bu_id")
    private Long applyBuId;
    @UdcName(udcName = "BU", codePropName = "applyBuId")
    private String applyBuName;
    /**
     * 申请人专业级别
     */
    @ApiModelProperty("申请人专业级别")
    private String applyResLevel;
    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    private BigDecimal applyAmt;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 预计使用日期
     */
    @ApiModelProperty("预计使用日期")
    private LocalDate expectDate;
    /**
     * 报销模板id
     */
    @ApiModelProperty("报销模板id")
    private Long reimTmplId;
    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    private Long custId;
    private String custName;
    /**
     * 费用承担公司id
     */
    @ApiModelProperty("费用承担公司id")
    private Long ouId;
    private String ouName;
    /**
     * 费用承担方（类型）
     */
    @ApiModelProperty("费用承担方（类型）")
    private String expenseByType;
    @UdcName(udcName = "salecon:cust_bear", codePropName = "expenseByType")
    private String expenseByTypeDesc;
    /**
     * 项目非项目
     */
    @ApiModelProperty("项目非项目")
    private String applyType;
    /**
     * 费用码
     */
    @ApiModelProperty("费用码")
    private String feeCode;

    @ApiModelProperty("报销单ID")
    private Long reimId;

    /**
     * 出差申请详情
     */
    @ApiModelProperty("出差申请详情")
    private List<AdmFeeApplyDetailVO> detailVOs;
}
