package com.elitesland.tw.tw5.api.prd.humanresources.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

@Data
public class ResWithdrawApplyQuery extends TwQueryParam {

    @ApiModelProperty("提现单号")
    private String withdrawNo;

    @ApiModelProperty("资源")
    private Long applyUserId;

    @ApiModelProperty("资源列表(提现付款用)")
    private Long[] applyUserIds;

    @ApiModelProperty("内部资源类型")
    private String resType;

    @ApiModelProperty("审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("申请日期开始")
    private LocalDate applyDateStart;

    @ApiModelProperty("申请日期结束")
    private LocalDate applyDateEnd;

    @ApiModelProperty("合作方式")
    private String cooperationMode;

    @ApiModelProperty("提现付款状态:APPROVING 付款审批中,APPROVED 付款已审批,PAID 已付款")
    private String[] withdrawPayStatus;

    @ApiModelProperty("采购协议编号")
    private String docNo;

    @ApiModelProperty("提现当量")
    private BigDecimal withdrawEqva;

    @ApiModelProperty("提现金额")
    private BigDecimal withdrawAmt;

}
