package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 权限申请
 *
 * @author lemon
 * @date 2023-09-11
 */
@Getter
@Setter
public class TPermissionApplyPayload extends TwCommonPayload  implements Serializable {
    /** 申请人 */
    @ApiModelProperty("申请人")
    private Long applyResId;
    /** 申请人部门 */
    @ApiModelProperty("申请人部门")
    private Long applyBuId;
    /** 任务名称 */
    @ApiModelProperty("任务名称")
    private String applyDate;
    /** 申请人手机号码 */
    @ApiModelProperty("申请人手机号码")
    private String applyResPhone;
    /** 申请权限说明 */
    @ApiModelProperty("申请权限说明")
    private String applyContent;
    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}
