package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 假期取消申请
 *
 * @author carl
 * @date 2024-06-18
 */
@Getter
@Setter
public class TUserVacationCancelPayload extends TwCommonPayload implements Serializable {
    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    private Long userId;
    /**
     * 用户名称
     */
    @ApiModelProperty("用户名称")
    private String userName;
    /**
     * 直属领导id
     */
    @ApiModelProperty("直属领导id")
    private Long pUserId;
    /**
     * 部门id
     */
    @ApiModelProperty("部门id")
    private Long orgId;
    /**
     * 请假id
     */
    @ApiModelProperty("请假id")
    private Long applyId;
    /**
     * 公司id
     */
    @ApiModelProperty("公司id")
    private Long companyId;
    /**
     * 请假单号
     */
    @ApiModelProperty("请假单号")
    private String applyNo;
    /**
     * 操作类型
     */
    @ApiModelProperty("操作类型")
    private String operType;
    /**
     * 阶段活动名称
     */
    @ApiModelProperty("阶段活动名称")
    private String cancelDesc;
    /**
     * 操作日期
     */
    @ApiModelProperty("操作日期")
    private LocalDate cancelDate;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String procInstStatus;
    /**
     * 流程id
     */
    @ApiModelProperty("流程id")
    private String procInstId;

    @ApiModelProperty("请假数据")
    private UserVacationApplyPayload userVacationApplyPayload;
}
