package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 外勤办公申请
 *
 * @author carl
 * @date 2024-05-22
 */
@Getter
@Setter
public class OutWorkApplyQuery extends TwQueryParam implements Serializable {
    /**
     * 主键id 精确
     */
    @ApiModelProperty("主键id")
    private Long id;
    /**
     * 外出申请人id 精确
     */
    @ApiModelProperty("外出申请人id")
    private Long applyUserId;
    /**
     * 归属bu_id 精确
     */
    @ApiModelProperty("归属bu_id")
    private Long orgId;
    /**
     * base地id 精确
     */
    @ApiModelProperty("base地id")
    private String baseAddrId;
    /**
     * 直属领导id 精确
     */
    @ApiModelProperty("直属领导id")
    private Long parentUserId;
    /**
     * 岗位 精确
     */
    @ApiModelProperty("岗位")
    private String jobs;
    /**
     * 级别
     */
    @ApiModelProperty("级别")
    private String grade;
    /**
     * 申请日期 精确
     */
    @ApiModelProperty("申请日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDateStart;

    /**
     * 申请日期开始 精确
     */
    @ApiModelProperty("申请日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyStartDate;

    /**
     * 申请日期结束 精确
     */
    @ApiModelProperty("申请日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyEndDate;
    /**
     * 外勤办公日期开始 精确
     */
    @ApiModelProperty("外勤办公日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate outWorkStartDate;

    /**
     * 外勤办公日期结束 精确
     */
    @ApiModelProperty("外勤办公日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate outWorkEndDate;

    /**
     * 外勤工作天数 精确
     */
    @ApiModelProperty("外勤工作天数")
    private BigDecimal outWorkDays;
    /**
     * 0.5天区分上午下午 AM上午 PM下午 精确
     */
    @ApiModelProperty("0.5天区分上午下午 AM上午 PM下午")
    private String outWorkInterval;
    /**
     * 外勤工作地 精确
     */
    @ApiModelProperty("外勤工作地")
    private String outWorkAddr;
    /**
     * 编号 模糊
     */
    @ApiModelProperty("编号")
    private String applyNo;
    /**
     * 名称 模糊
     */
    @ApiModelProperty("名称")
    private String applyName;
    /**
     * 任务状态 精确
     */
    @ApiModelProperty("任务状态")
    private String applyStatus;
    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String procInstStatus;
    /**
     * 流程id 精确
     */
    @ApiModelProperty("流程id")
    private String procInstId;
}
