package com.elitesland.tw.tw5.api.prd.partner.strategy.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 分级策略模型指标
 *
 * @author wangly
 * @date 2023-06-19
 */
@Getter
@Setter
public class BusinessModelIndexQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 模型id business_strategy_model.id 精确 */
    @ApiModelProperty("模型id business_strategy_model.id")
    private Long modelId;
    /** 指标名称 精确 */
    @ApiModelProperty("指标名称")
    private String modelIndexName;
    /** 数据库字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD] 精确 */
    @ApiModelProperty("数据库字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD]")
    private String sourceField;
    /** 权重 精确 */
    @ApiModelProperty("权重")
    private BigDecimal weight;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 精确 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 精确 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
}
