package com.elitesland.tw.tw5.api.common.funConfig.query;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务对象表
 *
 * @author duwh
 * @date 2023-06-14
 */
@Getter
@Setter
public class TableQuery implements Serializable{

    /** 数据库表名 精确 */
    @ApiModelProperty("数据库表名")
    private String tableName;

    private static final int DEFAULT_PAGE_INDEX = 1;
    private static final int DEFAULT_PAGE_SIZE = 10;

    /**
     * 页码，默认为1
     */
    @ApiModelProperty(value = "页码", example = "1")
    private Integer current = DEFAULT_PAGE_INDEX;

    /**
     * 页大小，默认为10
     */
    @ApiModelProperty(value = "页大小", example = "10")
    private Integer size = DEFAULT_PAGE_SIZE;
}
