package com.elitesland.tw.tw5.api.prd.borrow.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
    import java.time.LocalDate;
    import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.List;

/**
 * 借款管理
 *
 * @author wangly
 * @date 2024-07-15
 */
@Getter
@Setter
public class BorrowMoneyQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 借款编号 精确 */
    @ApiModelProperty("借款编号")
    private String borrowNo;
    /** 借款编号OR名称 */
    @ApiModelProperty("借款编号OR名称")
    private String borrowNoOrName;
    /** 借款名称 精确 */
    @ApiModelProperty("借款名称")
    private String borrowName;
    /** 申请人 精确 */
    @ApiModelProperty("申请人")
    private Long applicantUserId;
    /** 出让日期 精确 */
    @ApiModelProperty("出让日期")
    private LocalDate transferDate;
    /** 受让人ID 精确 */
    @ApiModelProperty("受让人ID")
    private Long receiveUserId;
    /** 受让人所属bu 精确 */
    @ApiModelProperty("受让人所属bu")
    private Long receiveBuId;
    /** 申请日期 精确 */
    @ApiModelProperty("申请日期")
    private LocalDate applicantTime;
    /** 申请人所属bu 精确 */
    @ApiModelProperty("申请人所属bu")
    private Long applicantBuId;
    /** 费用BU */
    @ApiModelProperty("费用BU")
    private Long costBuId;
    /** 单据状态 udc[BORROW_MONEY:STATUS] 精确 */
    @ApiModelProperty("单据状态 udc[BORROW_MONEY:STATUS]")
    private String apprStatus;
    /** 单据状态 udc[BORROW_MONEY:STATUS] 精确 */
    @ApiModelProperty("单据状态 udc[BORROW_MONEY:STATUS]")
    private List<String> apprStatusList;
    /** 业务类型 udc[BORROW_MONEY:BUSINESS_TYPE] 精确 */
    @ApiModelProperty("业务类型 udc[BORROW_MONEY:BUSINESS_TYPE]")
    private String businessType;
    /** 是否出让 精确 */
    @ApiModelProperty("是否出让")
    private Boolean transferFlag;
    /** 还款人ID */
    @ApiModelProperty("还款人ID")
    private Long repaymentUserId;
    /** 借款金额 精确 */
    @ApiModelProperty("借款金额")
    private BigDecimal borrowAmt;
    /** 已核销金额 精确 */
    @ApiModelProperty("已核销金额")
    private BigDecimal alreadyWriteOffAmt;
    /** 未核销金额 精确 */
    @ApiModelProperty("未核销金额")
    private BigDecimal unwriteOffAmt;
    /** 预计核销日期 精确 */
    @ApiModelProperty("预计核销日期")
    private LocalDate preWriteOffDate;
    /** 附件 精确 */
    @ApiModelProperty("附件")
    private String fileCodes;
    /** 收款账户 精确 */
    @ApiModelProperty("收款账户")
    private String accountNo;
    /** 户名 精确 */
    @ApiModelProperty("户名")
    private String holderName;
    /** 收款银行 精确 */
    @ApiModelProperty("收款银行")
    private String bankName;
    /** 扩展字段1 精确 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 精确 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 精确 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字4 精确 */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /** 扩展字5 精确 */
    @ApiModelProperty("扩展字5")
    private String ext5;
    /** 流程实例ID 精确 */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 精确 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 精确 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 精确 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("申请日期起")
    private LocalDate applicantTimeStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("申请日期止")
    private LocalDate applicantTimeEnd;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("出让日期起")
    private LocalDate transferDateStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("出让日期止")
    private LocalDate transferDateEnd;

    /**
     * 逾期标志 是：YES 否：NO 全部：ALL
     */
    @ApiModelProperty("逾期标志 是：YES 否：NO 全部：ALL")
    private String slippageFlag;
}
