package com.elitesland.tw.tw5.api.prd.budget.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 预算变更信息
 *
 * @author xxb
 * @date 2023-11-01
 */
@Getter
@Setter
public class BudgetChangePayload extends TwCommonPayload implements Serializable {


    @ApiModelProperty("预算变更内容")
    private BudgetPayload budgetPayload;

    @ApiModelProperty("变更简述")
    private String extString1;
    @ApiModelProperty("变更说明")
    private String extString2;
    @ApiModelProperty("后续措施")
    private String extString3;

    /**
     * 预算提交标志
     */
    @ApiModelProperty("预算提交标志")
    private Boolean submitFlag = false;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

}
