package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerDataVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author carl.wang
 * @Description: 客户管理
 * @date
 */
public interface CrmCustomerService {

    /**
     * @param payload
     * @Description 新增
     **/
    CrmCustomerVO insert(CrmCustomerPayload payload,boolean flag);

    /**
     * 批量导入
     * @param payloads
     */
    void batchInsert(List<CrmCustomerPayload> payloads);

    /**
     * @param payload
     * @Description 修改
     **/
    Long update(CrmCustomerPayload payload);

    /**
     * 修改省市区，需要清空值，所以单独处理
     *
     * @param payload
     **/
    Long updateProvinceCityDistrict(CrmCustomerPayload payload);

    /**
     * @param query
     * @return
     * @Description 分页查询
     **/
    PagingVO<CrmCustomerVO> paging(CrmCustomerQuery query);

    /**
     * @param key 主键
     * @return
     * @Description 详细查询
     **/
    CrmCustomerVO queryDetail(Long key);

    /**
     * @param bookId 地址薄主键
     * @return
     * @Description 详细查询
     **/
    CrmCustomerVO queryDetailByBookId(Long bookId);

    /**
     * @return
     * @Description 列表查询
     **/
    List<CrmCustomerDataVO> queryList();


    /**
     * @param keys 主键
     * @return
     * @Description 删除
     **/
    boolean deleteSoft(List<Long> keys);

    /**
     * @param key    主键
     * @param status 状态
     * @return boolean
     * @Description 修改状态
     **/
    boolean updateStatus(Long key, String status);

    /**
     * 查询修改记录
     *
     * @param query 查询条件
     * @return
     */
    PagingVO<PrdSystemLogVO> queryLogList(PrdSystemLogQuery query);

    /**
     * 批量下载
     *
     * @param response
     * @param query
     */
    void downloadBatch(HttpServletResponse response, CrmCustomerQuery query);

    /**
     * 查询客户下面的线索和商机的跟进记录
     *
     * @param customerId
     * @return
     */
    List<CrmFollowVO> queryFollowList(Long customerId, Boolean withActivityFollows);


    void changeCustomerGrade(Long customerId, String grade);

    int checkCustNameUnique(String custName);

    /**
     * 权限条件添加
     *
     * @param query
     */
    public void operPermissionFlag(CrmCustomerQuery query);


    /**
     * 根据客户id查询合同数量
     * @param customerId
     * @return
     */
    int queryContractNum(Long customerId);

    /**
     * 获取客户地址簿id
     * @param customerId
     */
    Long getCustBookId(Long customerId);


}
