package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResultPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResultQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResultVO;

import javax.servlet.http.HttpServletResponse;


/**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果Service
 */

public interface PrdPerformanceExamResultService {

    /**
     * 新增绩效考核结果数据
     *
     * @param prdPerformanceExamResultPayload
     * @return
     */
    PrdPerformanceExamResultVO save(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload);

    /**
     * 根据主键更新
     *
     * @param prdPerformanceExamResultPayload
     * @return
     */
    PrdPerformanceExamResultVO update(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PrdPerformanceExamResultVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param prdPerformanceExamResultQuery
     * @return
     */
    PagingVO<PrdPerformanceExamResultVO> page(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param prdPerformanceExamResultQuery
     * @return
     */
    List<PrdPerformanceExamResultVO> getList(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery);

    /**
     * 根据条件修改
     *
     * @param prdPerformanceExamResultPayload
     * @return
     */
    Long updateByCondition(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload);


    PrdPerformanceExamResultVO getBySelf(Long id);


    /**
     * 获取指定时间段内的用户的额定当量
     *
     * @return
     */
    BigDecimal getEdEqva(LocalDate startDate, LocalDate endDate, Long userId);


    /**
     * 根据范围id删除
     * @param ids
     */
    void delByRangeIds(List<Long> ids);
}

