package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class EmployeeDepartApplyVO extends BaseViewModel {

    @ApiModelProperty("离职资源")
    private Long employeeId;

    @ApiModelProperty("userId")
    private Long userId;

    @ApiModelProperty("离职资源名称")
    @UdcName(udcName = "USER", codePropName = "userId")
    private String employeeName;

    @ApiModelProperty("入职日期")
    private String enrollDate;

    @ApiModelProperty("BaseBu")
    private Long orgId;

    @ApiModelProperty("BaseBu名称")
    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;

    @ApiModelProperty("Base地")
    private String extString5;

//    @ApiModelProperty("所属公司")
//    private Long companyId;

    @ApiModelProperty("所属公司")
    private Long bookId;

    @ApiModelProperty("所属公司名称")
    private String companyName;

    @ApiModelProperty("直属领导")
    private Long parentId;

    @ApiModelProperty("直属领导")
    @UdcName(udcName = "USER", codePropName = "parentId")
    private String parentName;

    @ApiModelProperty("备注(离职原因)")
    private String leaveDesc;

    @ApiModelProperty("有无工作交接")
    private String jobHandOverFlag;

    @ApiModelProperty("工作交接人")
    private Long jobHandOverId;

    @ApiModelProperty("工作交接内容")
    private String jobContent;

    @ApiModelProperty("解除劳动合同日期")
    private String contractEndDate;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("邮箱设置")
    private String emailSet;

    @ApiModelProperty("邮件代收人")
    private Long emailReceiverId;

    @ApiModelProperty("最后工作日")
    private String lastJobDate;

    @ApiModelProperty("工号")
    private String employeeNo;

    @ApiModelProperty("离职原因")
    private String hrLeaveDescCode;

    @ApiModelProperty("离职原因说明")
    private String hrReason;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    private String procInstStatusDesc;

    @ApiModelProperty("流程名称")
    private String procInstName;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("离职办理事项-财务")
    private String leaveFinChk;

    @ApiModelProperty("离职办理事项-人事")
    private String leaveHrChk;

    @ApiModelProperty("离职办理事项-IT")
    private String leaveItChk;

    @ApiModelProperty("离职办理事项-资源")
    private String leaveResChk;

    @ApiModelProperty("离职办理事项-行政")
    private String leaveOffiChk;

    @ApiModelProperty("是否已安排休完剩余假期")
    private Boolean availableVacationUsedFlag;

    @ApiModelProperty("申请人")
    @UdcName(udcName = "USER", codePropName = "userId")
    private String createUserName;
}
