package com.elitesland.tw.tw5.api.prd.partner.common.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.AddressBookPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.AddressBookQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.AddressBookVO;

import java.util.List;

/**
 * 业务伙伴-地址薄
 *
 * @author wangluyu
 * @date 2023-05-16
 */
public interface AddressBookService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AddressBookVO}>
     */
    PagingVO<AddressBookVO> queryPaging(AddressBookQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AddressBookVO}>
     */
    List<AddressBookVO> queryListDynamic(AddressBookQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AddressBookVO}
     */
    AddressBookVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AddressBookVO}
     */
    AddressBookVO insert(AddressBookPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AddressBookVO}
     */
    AddressBookVO update(AddressBookPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
