package com.elitesland.tw.tw5.api.prd.pms.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectTemplateActPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectTemplateActQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateActVO;

import java.util.List;

/**
 * 项目模板活动
 *
 * @author xxb
 * @date 2023-08-03
 */
public interface PmsProjectTemplateActService {


    /**
     * 批量保存
     * @param actList
     */
    List<PmsProjectTemplateActVO> batchSave(List<PmsProjectTemplateActPayload> actList);

    /**
     * 通过 模板Id 查询
     *
     * @param templateId 模板Id
     * @return {@link PmsProjectTemplateActVO}
     */
    List<PmsProjectTemplateActVO> queryByTemplateId(Long templateId);


    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectTemplateActVO}>
     */
    PagingVO<PmsProjectTemplateActVO> queryPaging(PmsProjectTemplateActQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectTemplateActVO}>
     */
    List<PmsProjectTemplateActVO> queryListDynamic(PmsProjectTemplateActQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectTemplateActVO}
     */
    PmsProjectTemplateActVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsProjectTemplateActVO}
     */
    PmsProjectTemplateActVO insert(PmsProjectTemplateActPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectTemplateActVO}
     */
    PmsProjectTemplateActVO update(PmsProjectTemplateActPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsProjectTemplateActPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
