package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;

/**
 * 收款计划
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Data
public class ConReceivablePlanListExcelExport {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    @ExcelProperty(index = 0,value = "序号")
    private String order;
    /**
     * 收款号
     */
    @ExcelProperty(index = 1,value = "收款号")
    private String receNo;
    /**
     * 收款阶段
     */
    @ExcelProperty(index = 2,value = "收款阶段")
    private String receStage;
    /**
     * 当期收款金额
     */
    @ExcelProperty(index = 3,value = "当期收款金额")
    private BigDecimal receAmt;
    /**
     * 当期收款比例
     */
    @ExcelProperty(index = 4,value = "当期收款比例")
    private BigDecimal receRatio;
    /**
     * 预计收款日期
     */
    @ExcelProperty(index = 5,value = "预计收款日期")
    private String expectReceDate;
    /**
     * 收款状态
     */
//    private String receStatus;
    @ExcelProperty(index = 6,value = "收款状态")
    private String receStatusDesc;
    /**
     * 预计开票日期
     */
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ExcelProperty(index = 7,value = "预计开票日期")
    private String expectInvDate;
    /**
     * 开票状态
     */
//    private String invStatus;
    @ExcelProperty(index = 8,value = "开票状态")
    private String invStatusDesc;
    /**
     * 税率
     */
    @ExcelProperty(index = 9,value = "税率")
    private BigDecimal taxRate;
    /**
     * 开票日期
     */
    @ExcelProperty(index = 10,value = "开票日期")
    private String invDate;
    /**
     * 已开票金额
     */
    @ExcelProperty(index = 11,value = "已开票金额")
    private BigDecimal alreadyInvAmt;
    /**
     * 未开票金额
     */
    @ExcelProperty(index = 12,value = "未开票金额")
    private BigDecimal notInvAmt;
    /**
     * 已收款金额
     */
    @ExcelProperty(index = 13,value = "已收款金额")
    private BigDecimal alreadyReceAmt;
    /**
     * 实际收款日期
     */
//    private String actualReceDate;
    @ExcelProperty(index = 14,value = "实际收款日期")
    private String actualReceDateStr;

    /**
     * 未收款金额
     */
    @ExcelProperty(index = 15,value = "未收款金额")
    private BigDecimal notReceAmt;
    /**
     * 已确认金额
     */
    @ExcelProperty(index = 16,value = "已确认金额")
    private BigDecimal confirmedAmt;
    /**
     * 确认收入日期
     */
    @ExcelProperty(index = 17,value = "确认收入日期")
    private String confirmedAmtDate;
    /**
     * 备注
     */
    @ExcelProperty(index = 18,value = "备注")
    private String remark;
}
