package com.elitesland.tw.tw5.api.prd.system.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;


/**
 * 评价表
 *
 * @author duwh
 * @date 2022/11/22
 */
@Data
public class PrdCommentPayload extends TwCommonPayload {


    /**
     * 业务类型：枚举：经营计划：OPER_PLAN  ....
     */
    private String objType;

    /**
     * 业务主键
     */
    private Long objId;

    /**
     * 评论内容
     */
    private String content;

    /**
     * 安特@用户id集合 英文逗号隔开 11,22,33
     */
    private String annUserIds;

    /**
     * 评论人主键
     */
    private Long userId;

    /**
     * 评论人姓名 冗余
     */
    private String userName;

    /**
     * 评论人头像 冗余
     */
    private String userLogo;

    /**
     * 回复对象主键
     */
    private Long replyId;

    /**
     * 回复人主键
     */
    private Long replyUserId;

    /**
     * 回复人姓名 冗余
     */
    private String replyUserName;

    /**
     * 回复人头像 冗余
     */
    private String replyUserLogo;

    /**
     * 点赞数量
     */
    private Integer zanNum;

    /**
     * 收藏数量
     */
    private Integer collectNum;

    /**
     * 状态 预留
     */
    private String status;

    /**
     * 拓展1
     */
    private String ext1;

    /**
     * 拓展2
     */
    private String ext2;

    /**
     * 拓展3
     */
    private String ext3;

    /**
     * 拓展4
     */
    private String ext4;

    /**
     * 拓展5
     */
    private String ext5;


}
