package com.elitesland.tw.tw5.api.prd.adm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
    import java.time.LocalDate;
import java.util.List;

/**
 * 出差申请明细管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Getter
@Setter
public class AdmBusitripApplyDetailQuery extends TwQueryParam implements Serializable{
    /** 主键 精确 */
    @ApiModelProperty("主键")
    private Long id;
    /** 申请id 精确 */
    @ApiModelProperty("申请id")
    private Long applyId;
    /** 出差人资源id 精确 */
    @ApiModelProperty("出差人资源id")
    private Long tripResId;
    /** 出发地 精确 */
    @ApiModelProperty("出发地")
    private String fromPlace;
    /** 目的地 精确 */
    @ApiModelProperty("目的地")
    private String toPlace;
    /** 交通工具 精确 */
    @ApiModelProperty("交通工具")
    private String vehicle;
    /** 出发日期 精确 */
    @ApiModelProperty("出发日期")
    private LocalDate beginDate;
    /** 结束日期 精确 */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /** 出发时间段 大于等于 */
    @ApiModelProperty("出发时间段")
    private String beginTimespan;
    /** 结束时间段 小于等于 */
    @ApiModelProperty("结束时间段")
    private String endTimespan;
}
