package com.elitesland.tw.tw5.api.prd.adm.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 行政订票管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Getter
@Setter
@ExcelIgnoreUnannotated
public class AdmTripTicketVO extends BaseViewModel implements Serializable {
    /**
     * 申请id
     */
    @ApiModelProperty("申请id")
    private Long applyId;
    /**
     * 申请单名称
     */
    @ApiModelProperty("申请单名称")
    private String applyName;
    /**
     * 申请单号
     */
    @ApiModelProperty("申请单号")
    private String applyNo;
    /**
     * 订票费用类型
     */
    @ApiModelProperty("订票费用类型")
    private String ticketExpType;
    @UdcName(udcName = "ADM:BUSITRIP:EXPTYPE", codePropName = "ticketExpType")
    private String ticketExpTypeDesc;
    /**
     * 出差人资源id
     */
    @ApiModelProperty("出差人资源id")
    private Long tripResId;
    @UdcName(udcName = "USER", codePropName = "tripResId")
    @ExcelProperty(index = 7, value = "姓名")
    private String tripResName;
    /**
     * 订票人资源id
     */
    @ApiModelProperty("订票人资源id")
    private Long bookingResId;
    @UdcName(udcName = "USER", codePropName = "bookingResId")
    private String bookingResName;
    /**
     * 出发地
     */
    @ApiModelProperty("出发地")
    private String fromPlace;
    @UdcName(udcName = "SYSTEM_BASIC:PCD", codePropName = "fromPlace")
    @ExcelProperty(index = 4, value = "出发地")
    private String fromPlaceDesc;
    /**
     * 目的地
     */
    @ApiModelProperty("目的地")
    private String toPlace;
    @UdcName(udcName = "SYSTEM_BASIC:PCD", codePropName = "toPlace")
    @ExcelProperty(index = 5, value = "目的地")
    private String toPlaceDesc;
    /**
     * 交通工具
     */
    @ApiModelProperty("交通工具")
    private String vehicle;
    @UdcName(udcName = "ADM:BUSITRIP:VEHICLE", codePropName = "vehicle")
    private String vehicleDesc;
    /**
     * 出差日期
     */
    @ApiModelProperty("出差日期")
    private LocalDate tripDate;
    @ExcelProperty(index = 1, value = "出发日期")
    private String tripDateStr;

    /**
     * 时间段
     */
    @ApiModelProperty("时间段")
    @ExcelProperty(index = 3, value = "时间")
    private String timespan;
    /**
     * 订票日期
     */
    @ApiModelProperty("订票日期")
    private LocalDate bookingDate;
    @ExcelProperty(index = 0, value = "预定日期")
    private String bookingDateStr;
    /**
     * 车次航班
     */
    @ApiModelProperty("车次航班")
    @ExcelProperty(index = 2, value = "航班/车次")
    private String vehicleNo;
    /**
     * 金额
     */
    @ApiModelProperty("金额")
    @ExcelProperty(index = 8, value = "金额")
    private BigDecimal expAmt;
    /**
     * 票务使用状态
     */
    @ApiModelProperty("票务使用状态")
    private String useStatus;
    /**
     * 购票渠道
     */
    @ApiModelProperty("购票渠道")
    private String ticketPurchasingChannel;
    @UdcName(udcName = "ADM:BUSITRIP:CHANNEL", codePropName = "ticketPurchasingChannel")
    private String ticketPurchasingChannelDesc;
    /**
     * 报销状态
     */
    @ApiModelProperty("报销状态")
    private String reimbursementStatus;
    @UdcName(udcName = "ADM:BUSITRIP:REIM_STATE", codePropName = "reimbursementStatus")
    private String reimbursementStatusDesc;


    private LocalDateTime reimTime;
    @ExcelProperty(index = 6, value = "报销时间")
    private String reimTimeStr;

    @ApiModelProperty("客户承担费用")
    private String expenseByType;
    @UdcName(udcName = "salecon:cust_bear", codePropName = "expenseByType")
    @ExcelProperty(index = 9, value = "公司承担/客户承担")
    private String expenseByTypeName;


}
