package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 客户经营-经营计划明细表
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
public class CrmOperationPlanDetailPayload extends TwCommonPayload {

    /**
     * 客户经营主键 crm_customer_operation.id
     */
    private Long operId;

    /**
     * 主表id 预留字段 暂无用
     */
    private Long planId;

    /**
     * 计划名称
     */
    private String planName;

    /**
     * 计划内容
     */
    private String planContent;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endTime;

    /**
     * 优先级 udc[crm:oper_plan:priority]
     */
    private String priority;

    /**
     * 状态 udc[crm:oper_plan:status]
     */
    private String status;

    /**
     * 执行者
     */
    private Long performerId;

    /**
     * 已读标记，0：未读，1：已读
     */
    private Integer readFlag;

    /**
     * 参与者集合
     */
    private List<CrmOperationPlanDetailMemberPayload> memberList;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

    /**
     * 经营计划新增时，附件文件编码，逗号分隔
     */
    private String fileCodes;

}
