package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * 客户经营-经营计划明细
 *
 * @author duwh
 * @date 2022/11/17
 */
public interface CrmOperationPlanDetailService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmOperationPlanDetailVO}
     */
    CrmOperationPlanDetailVO insert(CrmOperationPlanDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CrmOperationPlanDetailVO}
     */
    CrmOperationPlanDetailVO update(CrmOperationPlanDetailPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    CrmOperationPlanDetailVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link CrmOperationPlanDetailVO}>
     */
    List<CrmOperationPlanDetailVO> queryList(CrmOperationPlanDetailQuery query);

    /**
     * 查询列表 数据权限
     *
     * @param query 查询
     * @return {@link List}<{@link CrmOperationPlanDetailVO}>
     */
    List<CrmOperationPlanDetailVO> queryListDataFilter(CrmOperationPlanDetailQuery query);

    /**
     * 数
     *
     * @param query 查询
     * @return long
     */
    long count(CrmOperationPlanDetailQuery query);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<CrmOperationPlanDetailVO> paging(CrmOperationPlanDetailQuery query);

    /**
     * 分页数据权限
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link CrmOperationPlanDetailVO}>
     */
    PagingVO<CrmOperationPlanDetailVO> pagingDataFilter(CrmOperationPlanDetailQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据客户经营主键id集合 逻辑删除数据
     *
     * @param operIds 客户经营主键
     */
    void deleteSoftByOperIds(List<Long> operIds);

    /**
     * 批量保存
     *
     * @param planDetailPayloadS 请求集合
     */
    void saveAll(List<CrmOperationPlanDetailPayload> planDetailPayloadS);

    /**
     * 查询日志列表
     *
     * @param key 关键
     * @return {@link List}<{@link PrdSystemLogVO}>
     */
    List<PrdSystemLogVO> queryLogList(Long key);


    /**
     * 工时选择经营计划列表
     *
     * @return {@link List}<{@link CrmOperationPlanDetailVO}>
     */
    List<CrmOperationPlanDetailVO> listForTimeSheet();

}
