package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class UserVacationApplyPayload extends TwCommonPayload implements Serializable {

    @ApiModelProperty("userId")
    private Long userId;

//    @ApiModelProperty("BaseBu")
//    private Long orgId;
//
//    @ApiModelProperty("直属领导")
//    private Long parentId;
//
//    @ApiModelProperty("所属公司")
//    private Long companyId;
//
//    @ApiModelProperty("资源类型一")
//    private String extString6;
//
//    @ApiModelProperty("资源类型二")
//    private String extString9;

    @ApiModelProperty("假期id")
    private Long vacationId;

    @ApiModelProperty("请假单号")
    private String applyNo;

    @ApiModelProperty("请假类型")
    private String vacationType;

    @ApiModelProperty("请假天数")
    private BigDecimal vacationDays;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("开始时间")
    private LocalDate startDate;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("结束时间")
    private LocalDate endDate;

    @ApiModelProperty("附件")
    private String attachmentCodes;

    @ApiModelProperty("附件说明")
    private String attachmentDesc;

    @ApiModelProperty("是否在项目上")
    private Byte inProjectFlag;

    @ApiModelProperty("所在项目")
    private Long projectId;

    @ApiModelProperty("请假事由")
    private String reason;

    @ApiModelProperty("工作安排")
    private String workPlan;

    @ApiModelProperty("补充附件标志")
    private Byte addFlag;

    @ApiModelProperty("补充附件清单")
    private String addList;

    @ApiModelProperty("补充附件")
    private String vacationAddAttachCodes;

    @ApiModelProperty("是否需要延长假期")
    private Byte extVacationFlag;

    @ApiModelProperty("延长原因")
    private String extVacationReson;

    @ApiModelProperty("延长假期附件")
    private String extVacationAttachCodes;

//    @ApiModelProperty("延长原因")
//    private String extVacationAttach;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("延长开始时间")
    private LocalDate extVacationStartDate;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("延长结束时间")
    private LocalDate extVacationEndDate;

    @ApiModelProperty("延长天数")
    private BigDecimal extVacationDays;

    @ApiModelProperty("流程实例id")
    private String procInstId;

    @ApiModelProperty("流程状态")
    private ProcInstStatus ProcInstStatus;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("请假详情")
    List<UserVacationApplyDetailPayload> applyDetailPayloadList;

    @ApiModelProperty("延长请假详情")
    List<UserVacationApplyDetailPayload> extapplyDetailPayloadList;

    @ApiModelProperty("请假对应的任务数据（目前只针对奖励假）")
    List<TaskInfoVO> taskInfoVOS;

    /**
     * 钉钉审批实例业务编号
     */
    @ApiModelProperty("钉钉审批实例业务编号")
    private String businessId;

    /**
     * 钉钉流程实例id
     */
    @ApiModelProperty("钉钉流程实例id")
    private String processInstanceId;

    /**
     * 钉钉流程实例创建时间
     */
    @ApiModelProperty("钉钉流程实例创建时间")
    private LocalDateTime dingCreateTime;

}
