package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;

/**
* 任务包授权主表
*
* @author duwh
* @date 2022-12-16
*/
@Data
public class TaskAuthorizedQuery extends TwQueryParam{
    /** 授权名称 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String name;
    /** 授权编号 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String authorizedNo;
    /** 发包人v4 resId 精确 */
    @Query
    private Long disterResId;
    /** 发包人用户id 精确 */
    @Query
    private Long disterUserId;
    /** 精确 */
    @Query
    private Long receiverResId;
    /** 被授权人用户id 精确 */
    @Query
    private Long receiverUserId;
    /** 精确 */
    @Query
    private Long receiverBuId;
    /** 精确 */
    @Query
    private Long receiverOrgId;
    /** 精确 */
    @Query
    private String resSourceType;
    /** 精确 */
    @Query
    private String reasonType;
    /** 精确 */
    @Query
    private Long reasonId;
    /** 精确 */
    @Query
    private Long reasonIdV5;
    /** 精确 */
    @Query
    private Long expenseBuId;
    /** 精确 */
    @Query
    private Long expenseOrgId;
    /** 精确 */
    @Query
    private String apprStatus;
    /** 精确 */
    @Query
    private String applyStatus;
    /** 精确 */
    @Query
    private Boolean authResPlanFlag;
}
