package com.elitesland.tw.tw5.api.prd.my.service;


import com.elitesland.tw.tw5.api.prd.my.query.PrdUserMessageQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserMessageTypeVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserMessageVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdUserMessageService {


    /**
     * 查询所有未读信息总数
     *
     * @return result
     */
    Long queryTotal();

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    boolean deleteSoft(List<Long> keys);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdUserMessageVO queryByKey(Long key);

    /**
     * 分页查询
     *
     * @return 分页结果
     */
    PagingVO<PrdUserMessageVO> paging(PrdUserMessageQuery query);

    /**
     * 一键发布
     *
     * @param keys
     * @return
     */
    boolean onKeyUpdateStatus(List<Long> keys);
    /**
     * 查询未读消息类别列表以
     * @return result
     */
    List<PrdUserMessageTypeVO> findUnreadMessageTypeList();

    /**
     * 根据消息类别查询未读消息列表
     * @return result
     */
    List<PrdUserMessageVO> findUnreadMessageListByType(String contentType);
}
