package com.elitesland.tw.tw5.api.prd.my.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 工时用-项目表
 *
 * @author duwh
 * @date 2022-12-09
 */
@Data
public class ProjectAndTaskVO {

    /**
     * 项目PROJ、任务包TASK
     * 否则数据异常
     * <p>
     * 任务包 再根据reasonType 事由类型 01 项目 02 售前 03 bu 区分
     */
    private String typeDesc;

    /**
     * 项目or任务名称
     */
    private String commonName;

    /**
     * 项目or任务编号
     */
    private String commonNo;

    public String getTypeDesc() {
        if (null != projIdV4) {
            typeDesc = "PROJ";
        } else if (null != taskIdV4) {
            typeDesc = "TASK";
        } else {
            typeDesc = "ERROR";
        }
        return typeDesc;
    }

    public String getCommonName() {
        if (null != projIdV4) {
            commonName = projName;
        } else if (null != taskIdV4) {
            commonName = taskName;
        }
        return commonName;
    }

    public String getCommonNo() {
        if (null != projIdV4) {
            commonNo = projNo;
        } else if (null != taskIdV4) {
            commonNo = taskNo;
        }
        return commonNo;
    }

    // 项目相关
    /**
     * 4.0项目主键
     */
    private Long projIdV4;
    /**
     * 项目名称
     */
    private String projName;
    /**
     * 项目编号
     */
    private String projNo;
    /**
     * 项目状态
     */
    private String projStatus;


    //  任务包相关
    /**
     * 4.0任务主键
     */
    private Long taskIdV4;
    /**
     * 任务编号
     */
    private String taskNo;
    /**
     * 任务名称
     */
    private String taskName;
    /**
     * 任务状态
     */
    private String taskStatus;
    /**
     * 任务当量
     */
    private BigDecimal eqvaQty;
    /**
     * 发包资源id
     */
    private Long disterUserId;
    /**
     * 费用承担bu_id
     */
    private Long expenseBuId;
    /**
     * 接收资源bu_id
     */
    private Long receiverBuId;
    /**
     * 接收资源id
     */
    private Long receiverUserId;
    /**
     * 事由类型 01 项目 02 售前 03 bu
     */
    private String reasonType;
    /**
     * 事由id
     */
    private Long reasonId;
    /**
     * 4.0事由id
     */
    private Long reasonIdv4;
    /**
     * 事由名称冗余
     */
    private String reasonName;

    /**
     * 当类型是任务的时候 ，活动列表有数据，默认取第一条
     */
    private List<ResActivityVO> activityList;

    /**
     * 项目类型 ext1=OPER 代表经营类项目
     */
    private String ext1;
    /**
     * 项目类型 ext2 代表经营类项目的交付BU组织主键
     */
    private String ext2;

    /**
     * 是否是我的项目 （我在项目成员里）
     */
    private Boolean myProject = false;

    /**
     * 任务包- 工时填报剩余可用当量
     */
    private BigDecimal effectiveEqva;

    public BigDecimal getEffectiveEqva() {
        if(null == effectiveEqva){
            effectiveEqva = BigDecimal.ZERO;
        }
        return effectiveEqva;
    }

}
