package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;


/**
 * 业务伙伴-联系信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BookContactsVO extends BaseViewModel implements Serializable {
    /** 地址薄id */
    @ApiModelProperty("地址薄id")
    private Long bookId;
    /** 联系人类型 */
    @ApiModelProperty("联系人类型 udc[CRM:BUSINESS_PARTNER:CONTACTS_TYPE]")
    private String contactsType;

    /** 联系人类型 */
    @ApiModelProperty("联系人类型")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:CONTACTS_TYPE",codePropName = "contactsType" )
    private String contactsTypeDesc;
    /** 联系人姓名 */
    @ApiModelProperty("联系人姓名")
    private String contactsName;
    /** 联系人手机 */
    @ApiModelProperty("联系人手机")
    private String contactsPhone;
    /** 联系人电话 */
    @ApiModelProperty("联系人电话")
    private String contactsTelephone;
    /** 邮箱 */
    @ApiModelProperty("邮箱")
    private String contactsEmail;
    /** 联系地址 */
    @ApiModelProperty("联系地址")
    private String contactsAddress;
    /** 社交账户类型 */
    @ApiModelProperty("社交账户类型")
    private String socialAccountType;
    /** 社交账户 */
    @ApiModelProperty("社交账户")
    private String socialAccount;
    /** 部门 */
    @ApiModelProperty("部门")
    private String contactsDepartment;
    /** 岗位 */
    @ApiModelProperty("岗位")
    private String contactsPosition;
    /** 联系人关系 */
    @ApiModelProperty("联系人关系")
    private String contactsRelation;
    /** 性别 udc[org:employee:sex] */
    @ApiModelProperty("性别 udc[org:employee:sex]")
    private String sex;
    /** 性别 udc[org:employee:sex] */
    @ApiModelProperty("性别 udc[org:employee:sex]")
    @UdcName(udcName = "org:employee:sex",codePropName = "sex")
    private String sexDesc;
    /** 生日 */
    @ApiModelProperty("生日")
    private LocalDate birthday;
    /** 是否是关键决策人 */
    @ApiModelProperty("是否是关键决策人")
    private Boolean isKeyPerson;
    /** 联系人编号 */
    @ApiModelProperty("联系人编号")
    private String contactsNo;
    /** 联系人状态 */
    @ApiModelProperty("联系人状态 udc[CRM:BUSINESS_PARTNER:CONTACTS_STATUS]")
    private String contactsStatus;

    /** 联系人状态 */
    @ApiModelProperty("联系人状态")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:CONTACTS_STATUS",codePropName = "contactsStatus")
    private String contactsStatusDesc;

    /** 是否为默认联系人信息 */
    @ApiModelProperty("是否为默认联系人信息")
    private Boolean isDefault;

    /** 业务伙伴名称 */
    @ApiModelProperty("业务伙伴名称")
    private String bookName;
}
