package com.elitesland.tw.tw5.api.prd.pay.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.TDocHistPayload;
import com.elitesland.tw.tw5.api.prd.pay.query.TDocHistQuery;
import com.elitesland.tw.tw5.api.prd.pay.vo.TDocHistVO;

import java.util.List;

/**
 * 支付管理-支付履历
 *
 * @author wangly
 * @date 2023-12-12
 */
public interface TDocHistService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TDocHistVO}>
     */
    PagingVO<TDocHistVO> queryPaging(TDocHistQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TDocHistVO}>
     */
    List<TDocHistVO> queryListDynamic(TDocHistQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TDocHistVO}
     */
    TDocHistVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TDocHistVO}
     */
    TDocHistVO insert(TDocHistPayload payload);

    /**
     * 批量插入
     *
     * @param payloads
     */
    void batchInsert(List<TDocHistPayload> payloads);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TDocHistVO}
     */
    TDocHistVO update(TDocHistPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TDocHistPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
