package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 项目汇报管理
 *
 * @author carl
 * @date 2023-09-05
 */
@Getter
@Setter
public class PmsProjectBriefPayload extends TwCommonPayload implements Serializable {
    /**
     * 汇报编号
     */
    @ApiModelProperty("汇报编号")
    private String briefNo;
    /**
     * 汇报状态
     */
    @ApiModelProperty("汇报状态")
    private String briefStatus;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 财务期间id
     */
    @ApiModelProperty("财务期间id")
    private LocalDate finPeriodDate;
    /**
     * 提交日期
     */
    @ApiModelProperty("提交日期")
    private LocalDate applyDate;
    /**
     * 提交资源userid
     */
    @ApiModelProperty("提交资源userid")
    private Long applyUserId;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 费用预算总金额
     */
    @ApiModelProperty("费用预算总金额")
    private BigDecimal feeBudgetAmt;
    /**
     * 费用预算已拨付金额
     */
    @ApiModelProperty("费用预算已拨付金额")
    private BigDecimal feeReleasedAmt;
    /**
     * 费用预算已使用金额
     */
    @ApiModelProperty("费用预算已使用金额")
    private BigDecimal feeUsedAmt;
    /**
     * 当量预算总数
     */
    @ApiModelProperty("当量预算总数")
    private BigDecimal eqvaBudgetCnt;
    /**
     * 当量预算总金额
     */
    @ApiModelProperty("当量预算总金额")
    private BigDecimal eqvaBudgetAmt;
    /**
     * 当量已拨付数量
     */
    @ApiModelProperty("当量已拨付数量")
    private BigDecimal eqvaReleasedQty;
    /**
     * 当量已拨付金额
     */
    @ApiModelProperty("当量已拨付金额")
    private BigDecimal eqvaReleasedAmt;
    /**
     * 当量已派发数量
     */
    @ApiModelProperty("当量已派发数量")
    private BigDecimal eqvaDistedQty;
    /**
     * 当量已派发金额
     */
    @ApiModelProperty("当量已派发金额")
    private BigDecimal eqvaDistedAmt;
    /**
     * 当量已结算数量
     */
    @ApiModelProperty("当量已结算数量")
    private BigDecimal eqvaSettledQty;
    /**
     * 当量已结算金额
     */
    @ApiModelProperty("当量已结算金额")
    private BigDecimal eqvaSettledAmt;
    /**
     * 当量派发百分比
     */
    @ApiModelProperty("当量派发百分比")
    private BigDecimal eqvaDistedPercnet;
    /**
     * 当量结算百分比
     */
    @ApiModelProperty("当量结算百分比")
    private BigDecimal eqvaSettledPercent;
    /**
     * 报告完工百分比
     */
    @ApiModelProperty("报告完工百分比")
    private BigDecimal reprotCompPercent;
    /**
     * 调整完工百分比
     */
    @ApiModelProperty("调整完工百分比")
    private BigDecimal confirmCompPercent;
    /**
     * 财务调整说明
     */
    @ApiModelProperty("财务调整说明")
    private String confirmCompDesc;
    /**
     * 项目金额
     */
    @ApiModelProperty("项目金额")
    private BigDecimal projAmt;
    /**
     * 已收款金额
     */
    @ApiModelProperty("已收款金额")
    private BigDecimal recvedAmt;
    /**
     * 已开票金额
     */
    @ApiModelProperty("已开票金额")
    private BigDecimal invoicedAmt;
    /**
     * 确认收入金额
     */
    @ApiModelProperty("确认收入金额")
    private BigDecimal confirmedAmt;
    /**
     * 当期确认收入
     */
    @ApiModelProperty("当期确认收入")
    private BigDecimal confirmAmt;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 实际确认收入百分比
     */
    @ApiModelProperty("实际确认收入百分比")
    private BigDecimal confirmedPercent;
    /**
     * 申请拨付费用金额
     */
    @ApiModelProperty("申请拨付费用金额")
    private BigDecimal applyFeeAmt;
    /**
     * 申请拨付当量数
     */
    @ApiModelProperty("申请拨付当量数")
    private BigDecimal applyEqvaCnt;
    /**
     * 申请拨付当量金额
     */
    @ApiModelProperty("申请拨付当量金额")
    private BigDecimal applyEqvaAmt;
    /**
     * 实际拨付费用金额
     */
    @ApiModelProperty("实际拨付费用金额")
    private BigDecimal approveFeeAmt;
    /**
     * 实际拨付当量数
     */
    @ApiModelProperty("实际拨付当量数")
    private BigDecimal approveEqvaCnt;
    /**
     * 实际拨付当量金额
     */
    @ApiModelProperty("实际拨付当量金额")
    private BigDecimal approveEqvaAmt;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 进度汇报说明
     */
    @ApiModelProperty("进度汇报说明")
    private String briefDesc;
    /**
     * 费用申请说明
     */
    @ApiModelProperty("费用申请说明")
    private String feeApplyDesc;
    /**
     * 当量申请说明
     */
    @ApiModelProperty("当量申请说明")
    private String eqvaApplyDesc;
    /**
     * 项目进度状态
     */
    @ApiModelProperty("项目进度状态")
    private String projProcessStatus;
    /**
     * 风险描述
     */
    @ApiModelProperty("风险描述")
    private String riskDesc;
    /**
     * 预计还会发生的报销费用
     */
    @ApiModelProperty("预计还会发生的报销费用")
    private BigDecimal predictReimAmt;
    /**
     * 预计还会发生的劳务费用
     */
    @ApiModelProperty("预计还会发生的劳务费用")
    private BigDecimal predictLaborAmt;
    /**
     * 已发生的劳务费用
     */
    @ApiModelProperty("已发生的劳务费用")
    private BigDecimal passedLaborAmt;
    /**
     * 自动汇报标识
     */
    @ApiModelProperty("自动汇报标识")
    private Integer autoReportFlag;
}
