package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 项目汇报计划管理
 *
 * @author carl
 * @date 2023-09-05
 */
@Getter
@Setter
public class PmsProjectReportPlanPayload extends TwCommonPayload implements Serializable {
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 期间
     */
    @ApiModelProperty("期间")
    private LocalDate periodDate;
    /**
     * 金额
     */
    @ApiModelProperty("金额")
    private BigDecimal amt;
    /**
     * 项目汇报id
     */
    @ApiModelProperty("项目汇报id")
    private Long briefId;
    /**
     * 汇报编号
     */
    @ApiModelProperty("汇报编号")
    private String briefNo;
}
