package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.BuProjectMembersPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectMembersVO;

import java.util.List;

/**
 * BU项目成员管理
 *
 * @author carl
 * @date 2023-11-29
 */
public interface BuProjectMembersService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BuProjectMembersVO}>
     */
    PagingVO<BuProjectMembersVO> queryPaging(BuProjectMembersQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BuProjectMembersVO}>
     */
    List<BuProjectMembersVO> queryListDynamic(BuProjectMembersQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BuProjectMembersVO}
     */
    BuProjectMembersVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BuProjectMembersVO}
     */
    BuProjectMembersVO insert(BuProjectMembersPayload payload);

//    /**
//     * 修改
//     *
//     * @param payload 单据数据
//     * @return {@link BuProjectMembersVO}
//     */
//    BuProjectMembersVO update(BuProjectMembersPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BuProjectMembersPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
