package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSummarySettingPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSummarySettingQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSummarySettingVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;

import java.util.List;

/**
 * 会议纪要配置
 *
 * @author zoey
 * @date 2024-05-28
 */
public interface PmsProjectSummarySettingService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectSummarySettingVO}>
     */
    PagingVO<PmsProjectSummarySettingVO> queryPaging(PmsProjectSummarySettingQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectSummarySettingVO}>
     */
    List<PmsProjectSummarySettingVO> queryListDynamic(PmsProjectSummarySettingQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectSummarySettingVO}
     */
    PmsProjectSummarySettingVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsProjectSummarySettingVO}
     */
    PmsProjectSummarySettingVO insert(PmsProjectSummarySettingPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectSummarySettingVO}
     */
    PmsProjectSummarySettingVO update(PmsProjectSummarySettingPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsProjectSummarySettingPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 项目列表
     *
     * @return
     */
    List<PmsProjectVO> queryProjList(Long pmResId, String workType);
}
