package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 项目事件日志功能管理
 *
 * @author carl
 * @date 2023-09-18
 */
@Getter
@Setter
public class PmsProjectEventLogVO extends BaseViewModel implements Serializable {
    /**
     * 项目主键
     */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    private String projNo;
    /**
     * 事件内容及来源
     */
    @ApiModelProperty("事件内容及来源")
    private String eventContentSource;
    /**
     * 可能产生的影响
     */
    @ApiModelProperty("可能产生的影响")
    private String possibleImpacts;
    /**
     * 所属类型
     */
    @ApiModelProperty("所属类型")
    private String type;
    @UdcName(udcName = "PMS_PROJECT_EVENT_TYPE", codePropName = "type")
    private String typeDesc;

    /**
     * 严重程度
     */
    @ApiModelProperty("严重程度")
    private String severity;
    @UdcName(udcName = "PMS:PROJECT:EVENT:SEVERITY", codePropName = "severity")
    private String severityDesc;
    /**
     * 发生几率
     */
    @ApiModelProperty("发生几率")
    private String probabilityOfOccurrence;
    @UdcName(udcName = "PMS:PROJECT:EVENT:ODDS", codePropName = "probabilityOfOccurrence")
    private String probabilityOfOccurrenceDesc;
    /**
     * 风险程度
     */
    @ApiModelProperty("风险程度")
    private String riskLevel;
    @UdcName(udcName = "PMS:PROJECT:RISK", codePropName = "riskLevel")
    private String riskLevelDesc;
    /**
     * 应对策略
     */
    @ApiModelProperty("应对策略")
    private String copingStrategy;
    /**
     * 预计结束时间
     */
    @ApiModelProperty("预计结束时间")
    private LocalDate expectedEndDate;
    /**
     * 负责人
     */
    @ApiModelProperty("负责人")
    private Long headResId;
    @UdcName(udcName = "USER", codePropName = "headResId")
    private String headResName;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String status;
    @UdcName(udcName = "PMS_PROJECT_EVENT_STATUS", codePropName = "status")
    private String statusDesc;
    /**
     * 延期天数（前端排序用）
     */
    @ApiModelProperty("延期天数（前端排序用）")
    private long delayDay;
    /**
     * 完成时间
     */
    @ApiModelProperty("完成时间")
    private LocalDateTime finishTime;

    /**
     * 项目经理资源id
     */
    @ApiModelProperty("项目经理资源id")
    private Long pmResId;
    @UdcName(udcName = "USER", codePropName = "pmResId")
    private String pmResName;

    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    private String deliBuName;
}
