package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.CostUndertakeDepartmentPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.CostUndertakeDepartmentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.CostUndertakeDepartmentVO;

import java.util.List;

/**
 * 费用承担部门
 *
 * @author likunpeng
 * @date 2023-11-07
 */
public interface CostUndertakeDepartmentService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CostUndertakeDepartmentVO}>
     */
    PagingVO<CostUndertakeDepartmentVO> queryPaging(CostUndertakeDepartmentQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CostUndertakeDepartmentVO}>
     */
    List<CostUndertakeDepartmentVO> queryListDynamic(CostUndertakeDepartmentQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CostUndertakeDepartmentVO}
     */
    CostUndertakeDepartmentVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CostUndertakeDepartmentVO}
     */
    CostUndertakeDepartmentVO insert(CostUndertakeDepartmentPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CostUndertakeDepartmentVO}
     */
    CostUndertakeDepartmentVO update(CostUndertakeDepartmentPayload payload);

    /**
     * 根据付款申请单id删除费用承担部门
     * @param paymentApplyId 付款申请单id
     */
    void deleteByPaymentApplyId(Long paymentApplyId);

    /**
     * 根据付款申请单ID查询列表
     *
     * @param paymentApplyId 付款申请单ID
     * @return {@link List}<{@link CostUndertakeDepartmentVO}>
     */
    List<CostUndertakeDepartmentVO> queryListByPaymentApplyId(Long paymentApplyId);

    /**
     * 根据发票号查询列表
     *
     * @param invoiceNo 发票号
     * @return {@link List}<{@link CostUndertakeDepartmentVO}>
     */
    List<CostUndertakeDepartmentVO> queryListByInvoiceNo(String invoiceNo);


    /**
     * 根据发票号批量查询列表
     *
     * @param payload 发票号
     * @return {@link List}<{@link CostUndertakeDepartmentVO}>
     */
    List<CostUndertakeDepartmentVO> queryListByInvoiceNos(PaymentSlipPayload payload);
    /**
     * 根据发票号和申请单id查询列表
     *
     * @param invoiceNo 发票号
     * @return {@link List}<{@link CostUndertakeDepartmentVO}>
     */
    List<CostUndertakeDepartmentVO> queryListByJdePaymentApplyIdOrInvoiceNo(String invoiceNo,Long paymentApplyId);

    /**
     *
     * 根据id批量更新Jde回传状态
     * @param ids 单据数据
     * @return {@link CostUndertakeDepartmentVO}
     */
    void  updateCostUndertakeDepartmentIds(List<Long>ids);

}
