package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 合同开票批次
 *
 * @author likunpeng
 * @date 2023-07-19
 */
@Getter
@Setter
public class ConInvBatchPayload extends TwCommonPayload  implements Serializable {
    /**
     * id列表
     */
    List<Long> ids;
    /** 批次号 */
    @ApiModelProperty("批次号")
    private String batchNo;
    /** 批次状态 已申请/待开票/已开票/已取消 */
    @ApiModelProperty("批次状态 已申请/待开票/已开票/已取消")
    private String batchStatus;
    /** prd_ab_invoice 发票信息ID */
    @ApiModelProperty("prd_ab_invoice 发票信息ID")
    private Long invoiceId;
    /** 发票抬头 */
    @ApiModelProperty("发票抬头")
    private String invTitle;
    /** 发票类型 */
    @ApiModelProperty("发票类型")
    private String invType;
    /** 税率 */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /** 递送方式 */
    @ApiModelProperty("递送方式")
    private String deliMethod;
    /** 收件人 */
    @ApiModelProperty("收件人")
    private String contactPerson;
    /** 收件人地址 文本录入 */
    @ApiModelProperty("收件人地址 文本录入")
    private String invAddr;
    /** 收件人电话 */
    @ApiModelProperty("收件人电话")
    private String invTel;
    /** 开户行 */
    @ApiModelProperty("开户行")
    private String bankName;
    /** 账号 */
    @ApiModelProperty("账号")
    private String accountNo;
    /** 开票日期 */
    @ApiModelProperty("开票日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate batchDate;
    /** 发票内容 */
    @ApiModelProperty("发票内容")
    private String invContent;
    /** 付款方式 */
    @ApiModelProperty("付款方式")
    private String payMethod;
    /** 开票说明 */
    @ApiModelProperty("开票说明")
    private String invDesc;
    /** 开票主体公司ID */
    @ApiModelProperty("开票主体公司ID")
    private Long invOuId;
    /** 开票金额 */
    @ApiModelProperty("开票金额")
    private BigDecimal invAmt;
    /** 是否自动保存开票信息到地址簿 0 不保存 1保存 */
    @ApiModelProperty("是否自动保存开票信息到地址簿 0 不保存 1保存")
    private Integer saveAbFlag;
    /** 预计到账日期 */
    @ApiModelProperty("预计到账日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate antiRecvDate;
    /** 地址 存放地址簿中的信息 */
    @ApiModelProperty("地址 存放地址簿中的信息")
    private String addr;
    /** 退票原因 */
    @ApiModelProperty("退票原因")
    private String disDisc;
    /** 收件人邮箱 */
    @ApiModelProperty("收件人邮箱")
    private String invEmail;
    /** 发票商品ID 关联 T_INVOICE_ITEM.ID */
    @ApiModelProperty("发票商品ID 关联 T_INVOICE_ITEM.ID")
    private Long invItemId;
    @ApiModelProperty("流程提交标志")
    private Boolean submit;
    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 合同收款计划ID集合
     */
    @ApiModelProperty("合同收款计划id集合")
    private List<Long> conReceivablePlanIds;
    /** 附件 */
    @ApiModelProperty("附件")
    private String fileCode;
    /** 附件 */
    @ApiModelProperty("附件文件夹")
    private String folderId;
//    /** 开票信息附件 */
//    @ApiModelProperty("开票信息附件")
//    private String invBatchInfoFileCode;
//    /** 附件 */
//    @ApiModelProperty("合同开票信息附件文件夹")
//    private String invBatchInfoFolderId;

    @ApiModelProperty("易道壳的authToken")
    private String authTokenByYdk;
    @ApiModelProperty("附件易道壳缓存key")
    private String cacheKey;

    /** 是否已经开票 */
    @ApiModelProperty("是否已经开票")
    private Integer alreadyInvFlag;

    /**
     * 产品大类（销售合同的销售大类）
     */
    @ApiModelProperty("产品大类")
    private String productClass;

    /**
     * 邮件接收人（内部）
     */
    @ApiModelProperty("邮件接收人（内部）")
    String recipientInner;

    /**
     * 邮件接收人（外部）
     */
    @ApiModelProperty("邮件接收人（外部）")
    String recipientOuter;

    /** 开票备注，将开票说明加工后传递百望 */
    @ApiModelProperty("开票备注")
    private String invRemark;

    /** 是否自动开票:1 是；0 否 */
    @ApiModelProperty("是否开票:1 是；0 否")
    private Integer invFlag;

    /** 邮件通知:1 是；0 否 */
    @ApiModelProperty("邮件通知:1 是；0 否")
    private Integer emailFlag;

    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;


    /**
     * 结算单已回收：0待回收；1已回收；null无回收状态
     */
    @ApiModelProperty("结算单已回收")
    private Integer recycleSettleFlag;

    /** jde单据公司 */
    @ApiModelProperty("jde单据公司")
    private String jdeCompany;
    /** jde单据号  */
    @ApiModelProperty("jde单据号 ")
    private String jdeDocumentNo;
    /** jde单据类型 */
    @ApiModelProperty("jde单据类型")
    private String jdeDocumentType;
    /** jde付款项 */
    @ApiModelProperty("jde付款项")
    private String jdePaymentItem;
    /** jde发票凭证 */
    @ApiModelProperty("jde发票凭证")
    private String jdeInvoiceVoucher;
    /** jde发票凭证失败原因 */
    @ApiModelProperty("jde发票凭证失败原因")
    private String jdeInvoiceFailReason;

    @ApiModelProperty("jde发票凭证状态")
    private String jdeInvoiceStatus;

    @ApiModelProperty("jde核销收款状态")
    private String jdeReceiveWriteOffStatus;

    private List<ConInvBatchInvdtlPayload> conInvBatchInvdtlPayloads;
}
