package com.elitesland.tw.tw5.api.prd.schedule.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;


@Getter
@Setter
public class PrdActivityCalendarVO extends BaseViewModel implements Serializable {
    /**
     * 活动标题
     */
    @ApiModelProperty("活动标题")
    private String title;
    /**
     * 活动类型
     */
    @ApiModelProperty("活动类型")
    private String type;
    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;
    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;
    /**
     * 活动城市
     */
    @ApiModelProperty("活动城市")
    private String city;
    /**
     * 活动地点
     */
    @ApiModelProperty("活动地点")
    private String location;
    /**
     * 活动规模
     */
    @ApiModelProperty("活动规模")
    private String scale;
    /**
     * 活动负责人
     */
    @ApiModelProperty("活动负责人")
    private Long manageUserId;
    @UdcName(udcName = "USER", codePropName = "manageUserId")
    private String manageUserName;
    /**
     * 参与人
     */
    @JsonIgnore
    private String participants;
    @ApiModelProperty("参与人")
    private List<Long> participantsList;
    private List<String> participantsNameList;
    /**
     * 直播地址
     */
    @ApiModelProperty("直播地址")
    private String liveUrl;


    /**
     * 项目名称（活动名称）
     */
    private String projectName;

    /**
     * 活动地址
     */
    private String activityAddr;

    private String sourceType;


    /**
     * 状态
     */
    private String status;

    /**
     * 是否可编辑
     */
    private Boolean editable;

    private Long scheduleId;

    private Boolean sync;
}
