package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionFieldObjRoleFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionFieldObjRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldObjRoleFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;

import java.util.List;
import java.util.Map;

/**
 * service
 *
 * @author wangding
 */
public interface PrdSystemRoleService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdSystemRoleVO insert(PrdSystemRolePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdSystemRolePayload payload);

    /**
     * 更改状态
     *
     * @param id 主键
     */
    Long updateStatus(Long id, Boolean enable);

//    /**
//     * 物理删除
//     *
//     * @param keys 主键
//     * @return result
//     */
//    boolean delete(List<Long> keys);

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    boolean deleteSoft(List<Long> keys);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdSystemRoleVO queryByKey(Long key);

    /**
     * 分页查询
     *
     * @return 分页结果
     */
    PagingVO<PrdSystemRoleVO> paging(PrdSystemRoleQuery query);

    /**
     * 列表查询
     *
     * @return 结果
     */
    List<PrdSystemRoleVO> queryList();

    /**
     * 根据编号查询userId
     *
     * @param roleNo
     * @return
     */
    List<Long> queryUserIdByRoleCode(String roleNo);

    /**
     * 角色下的用户列表 模糊分页
     *
     * @param query
     * @return
     */
    PagingVO<PrdOrgEmployeeVO> pagingUserList(PrdSystemRoleFunctionQuery query);

    /**
     * 角色下 展示的用户列表需要提供一个关系移除
     *
     * @param roleId
     * @param userId
     * @return
     */
    void deleteUserList(Long roleId, Long userId);

    /**
     * 角色下 功能列表 模糊分页
     *
     * @param query
     * @return
     */
    PagingVO<PrdSystemRoleFunctionVO> pagingFunctionList(PrdSystemRoleFunctionQuery query);

    /**
     * 角色下 字段列表 模糊分页
     *
     * @param query
     * @return
     */
    PagingVO<PrdSystemPermissionFieldObjRoleFunctionVO> pagingField(PrdSystemPermissionFieldObjRoleFunctionQuery query);

    /**
     * 角色下 字段列表 字段属性值更改
     *
     * @param payloads
     * @return
     */
    void updateField(List<PrdSystemPermissionFieldObjRoleFunctionPayload> payloads);

    /**
     * 业务/管理角色列表查询
     *
     * @param query
     * @return
     */
    List<PrdSystemRoleVO> differentList(PrdSystemRoleQuery query);

    /**
     * 根据编号查询userId
     *
     * @param roleCodes 角色编号
     * @return 用户IDList
     */
    Map<String, List<Long>> queryUserIdMapByRoleCodes(List<String> roleCodes);

    /**
     * 根据角色获取用户id列表
     *
     * @return
     */
    List<Long> queryUserIdByRoleCodes(List<String> roleCodeList);

    /**
     * 添加角色
     *
     * @param userList
     * @param roleCode
     */
    void addUserMenu(List<Long> userList, String roleCode);
}
