package com.elitesland.tw.tw5.api.prd.visit.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 销售拜访任务管理
 *
 * @author duwh
 * @date 2023-03-13
 */
@Getter
@Setter
public class VisitTaskVO extends BaseViewModel implements Serializable {
    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String createUserName;
    /**
     * 拜访计划主键
     */
    @ApiModelProperty("拜访计划主键")
    private Long planId;
    /**
     * 任务名称
     */
    @ApiModelProperty("任务名称")
    private String taskName;
    /**
     * 任务编号
     */
    @ApiModelProperty("任务编号")
    private String taskNo;
    /**
     * 拜访计划名称（冗余）
     */
    @ApiModelProperty("拜访计划名称（冗余）")
    private String planName;
    /**
     * 拜访计划类型（冗余）
     */
    @ApiModelProperty("拜访计划类型（冗余）")
    private String planType;
    /**
     * 拜访客户主键 crm_customer.id  see partnerId
     */
    @ApiModelProperty("拜访客户主键 crm_customer.id  see partnerId")
    @Deprecated
    private Long customerId;
    /**
     * 业务伙伴主键（客户主表） business_partner.id
     */
    @ApiModelProperty("业务伙伴主键（客户主表） business_partner.id")
    private Long partnerId;

    /**
     * 拜访客户名称（冗余）crm_customer.customer_name
     */
    @ApiModelProperty("拜访客户名称（冗余）crm_customer.customer_name")
    private String customerName;
    /**
     * 客户地址
     */
    @ApiModelProperty("客户地址")
    private String customAdress;
    /**
     * 地址簿id
     */
    private Long bookId;
    @ApiModelProperty("详细地址")
    private String companyAddress;
    @ApiModelProperty("经纬度")
    private String longitudeLatitude;
    /**
     * 联系人姓名
     */
    private String contactsName;
    /**
     * 联系人手机
     */
    private String contactsPhone;
    /**
     * 任务状态 udc[crm:visit:task_status](已完成OK、待提交READY、未开始NEW)
     */
    @ApiModelProperty("任务状态 udc[crm:visit:task_status](已完成OK、待提交READY、未开始NEW)")
    private String status;
    @UdcName(udcName = "crm:visit:task_status", codePropName = "status")
    @ApiModelProperty("任务状态 udc[crm:visit:task_status](已完成OK、待提交READY、未开始NEW)")
    private String statusDesc;
    /**
     * 拜访成员
     */
    @ApiModelProperty("拜访成员")
    private Long visitMemberId;
    /**
     * 拜访成员 直属上级(冗余)
     */
    @ApiModelProperty("拜访成员 直属上级(冗余)")
    private Long visitMemberParentId;
    /**
     * 拜访成员 直属上级
     */
    @ApiModelProperty("拜访成员 直属上级")
    private Long visitMemberParentIdPro;
    /**
     * 拜访成员姓名
     */
    @ApiModelProperty("拜访成员姓名")
    private String visitMemberName;
    /**
     * 协防人员 多个英文逗号隔开
     */
    @ApiModelProperty("协防人员 多个英文逗号隔开")
    private String teamMemberIds;
    /**
     * 协防人员 多个英文逗号隔开
     */
    @ApiModelProperty("协防人员 多个英文逗号隔开")
    private String teamMemberNames;
    /**
     * 拜访开始时间
     */
    @ApiModelProperty("拜访开始时间")
    private LocalDate startTime;
    /**
     * 拜访结束时间
     */
    @ApiModelProperty("拜访结束时间")
    private LocalDate endTime;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间 | 完成时间")
    private LocalDateTime submitTime;
    /**
     * 关联信息类型（线索、商机OPPO、经营计划、销售目标）
     */
    @ApiModelProperty("关联信息类型（线索、商机OPPO、经营计划、销售目标）")
    private String objType;
    /**
     * 关联信息主键（关联主键)
     */
    @ApiModelProperty("关联信息主键（关联主键)")
    private Long objId;
    /**
     * 关联信息名称（冗余）
     */
    @ApiModelProperty("关联信息名称（冗余）")
    private String objName;
    /**
     * 计划创建人
     */
    @ApiModelProperty("计划创建人")
    private Long planCreateUserId;
    /**
     * 评价状态 NEW待评价 OK已评价
     */
    @ApiModelProperty("评价状态 NEW待评价 OK已评价")
    private String evalStatus;
    @UdcName(udcName = "crm:visit:task_eval_status", codePropName = "evalStatus")
    @ApiModelProperty("任务状态 udc[task_eval_status](NEW待评价 OK已评价)")
    private String evalStatusDesc;
    /**
     * 领导评分
     */
    @ApiModelProperty("领导评分")
    private Integer leaderGradle;
    /**
     * 下次拜访行动部署
     */
    @ApiModelProperty("下次拜访行动部署")
    private String nextPlan;
    /**
     * 客户评分
     */
    @ApiModelProperty("客户评分")
    private Integer customerGradle;
    /**
     * 客户建议
     */
    @ApiModelProperty("客户建议")
    private String customerAdvise;

    /**
     * 经度和纬度用","分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标。
     */
    @ApiModelProperty("经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标。")
    private String customerLocations;
    /**
     * 是否打卡范围，0：否，1：是
     */
    @ApiModelProperty("是否打卡范围，0：否，1：是")
    private Integer signRangeFlag;
    /**
     * 附件（录音）多个文件，英文逗号分隔
     */
    @ApiModelProperty("附件（录音）PrdFsmFileRefVO")
    private String fileCodes;
    @ApiModelProperty("附件（录音）PrdFsmFileRefVO")
    private Object fileDatas;
    /**
     * 客户情况说明
     */
    @ApiModelProperty("客户情况说明")
    private String customerDesc;
    /**
     * 拜访进展与结果
     */
    @ApiModelProperty("拜访进展与结果")
    private String result;
    /**
     * 下次拜访时间
     */
    @ApiModelProperty("下次拜访时间")
    private LocalDateTime nextVisitTime;

    /**
     * 客户意愿 udc[crm:visit:customer_willingness]
     */
    @ApiModelProperty("客户意愿 udc[crm:follow:cust_aspiration]")
    private String customerWillingness;
    @UdcName(udcName = "crm:follow:cust_aspiration", codePropName = "customerWillingness")
    private String customerWillingnessDesc;
    /**
     * 重大销售线索
     */
    @ApiModelProperty("重大销售线索")
    private String leads;
    /**
     * 市场感知反馈
     */
    @ApiModelProperty("市场感知反馈")
    private String marketFeedback;
    /**
     * 产品反馈
     */
    @ApiModelProperty("产品反馈")
    private String productFeedback;
    /**
     * 活动参与反馈
     */
    @ApiModelProperty("活动参与反馈")
    private String activityFeedback;
    /**
     * 其他需求反馈
     */
    @ApiModelProperty("其他需求反馈")
    private String otherFeedback;

    /**
     * 签到坐标（最新）
     */
    @ApiModelProperty("签到坐标（最新）")
    private String signLocations;
    /**
     * 签到地点（最新）
     */
    @ApiModelProperty("签到地点（最新）")
    private String signAddress;
    /**
     * 签到时间（最新）
     */
    @ApiModelProperty("签到时间（最新）")
    private LocalDateTime signTime;
    /**
     * 签到图片（最新）
     */
    @ApiModelProperty("签到图片（最新）")
    private String signFileCodes;
    /**
     * 签到图片（最新）
     */
    @ApiModelProperty("签到图片（最新）附件详情")
    private Object signFileDatas;
    /**
     * 签退坐标（最新）
     */
    @ApiModelProperty("签退坐标（最新）")
    private String signOutLocations;
    /**
     * 签退地点（最新）
     */
    @ApiModelProperty("签退地点（最新）")
    private String signOutAddress;
    /**
     * 签退时间（最新）
     */
    @ApiModelProperty("签退时间（最新）")
    private LocalDateTime signOutTime;
    /**
     * 签退图片（最新）
     */
    @ApiModelProperty("签退图片（最新）")
    private String signOutFileCodes;
    /**
     * 签退图片（最新）
     */
    @ApiModelProperty("签退图片（最新）附件详情")
    private Object signOutFileDatas;

    /**
     * 拓展字段1
     */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /**
     * 拓展字段2
     */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /**
     * 拓展字段3
     */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /**
     * 拓展字段4
     */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /**
     * 拓展字段5
     */
    @ApiModelProperty("拓展字段5")
    private String ext5;
    /**
     * 拓展字段6
     */
    @ApiModelProperty("拓展字段6")
    private String ext6;
    /**
     * 拓展字段7
     */
    @ApiModelProperty("拓展字段7")
    private String ext7;
    /**
     * 拓展字段8
     */
    @ApiModelProperty("拓展字段8")
    private String ext8;
    /**
     * 拓展字段9
     */
    @ApiModelProperty("拓展字段9")
    private String ext9;
    /**
     * 拓展字段10
     */
    @ApiModelProperty("拓展字段10")
    private String ext10;
    /**
     * 拓展字段11
     */
    @ApiModelProperty("拓展字段11")
    private String ext11;
    /**
     * 拓展字段12
     */
    @ApiModelProperty("拓展字段12")
    private String ext12;
    /**
     * 拓展字段13
     */
    @ApiModelProperty("拓展字段13")
    private String ext13;
    /**
     * 拓展字段14
     */
    @ApiModelProperty("拓展字段14")
    private String ext14;
    /**
     * 拓展字段15
     */
    @ApiModelProperty("拓展字段15")
    private String ext15;
    /**
     * 拓展字段16
     */
    @ApiModelProperty("拓展字段16")
    private String ext16;
    /**
     * 拓展字段17
     */
    @ApiModelProperty("拓展字段17")
    private String ext17;
    /**
     * 拓展字段18
     */
    @ApiModelProperty("拓展字段18")
    private String ext18;
    /**
     * 拓展字段19
     */
    @ApiModelProperty("拓展字段19")
    private String ext19;
    /**
     * 拓展字段20
     */
    @ApiModelProperty("拓展字段20")
    private String ext20;
    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /**
     * 拜访任务类型 udc[crm:visit:task_type]
     */
    @ApiModelProperty("拜访任务类型")
    private String taskType;
    @UdcName(udcName = "crm:visit:task_type", codePropName = "taskType")
    @ApiModelProperty("拜访任务类型")
    private String taskTypeDesc;
    /**
     * 页面配置主键 prd_business_page.id
     */
    @ApiModelProperty("页面配置主键 prd_business_page.id")
    private Long pageId;

    /**
     * 是否可以直接签到
     */
    @ApiModelProperty("是否可以直接签到")
    private Boolean showSignInFlag;

    /**
     * 客户阶段 udc[crm:customer_stage]
     */
    @ApiModelProperty("客户阶段 udc[crm:customer_stage]")
    private String customerStage;
}
