package com.elitesland.tw.tw5.api.prd.adm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 特殊费用申请管理
 *
 * @author carl
 * @date 2023-11-01
 */
@Getter
@Setter
public class AdmFeeApplyPayload extends TwCommonPayload implements Serializable {
    /**
     * 申请单号
     */
    @ApiModelProperty("申请单号")
    private String applyNo;
    /**
     * 申请单名称
     */
    @ApiModelProperty("申请单名称")
    private String applyName;
    /**
     * 申请状态
     */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例id
     */
    @ApiModelProperty("流程实例id")
    private String procInstId;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 财务期间id
     */
    @ApiModelProperty("财务期间id")
    private Long finPeriodId;
    /**
     * 用途类型
     */
    @ApiModelProperty("用途类型")
    private String usageType;
    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /**
     * 事由id
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 事由名称
     */
    @ApiModelProperty("事由名称")
    private String reasonName;
    /**
     * 费用承担bu_id
     */
    @ApiModelProperty("费用承担bu_id")
    private Long expenseBuId;
    /**
     * 费用归属bu_id
     */
    @ApiModelProperty("费用归属bu_id")
    private Long sumBuId;
    /**
     * 申请人资源id
     */
    @ApiModelProperty("申请人资源id")
    private Long applyResId;
    /**
     * 申请人bu_id
     */
    @ApiModelProperty("申请人bu_id")
    private Long applyBuId;
    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    private BigDecimal applyAmt;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 预计使用日期
     */
    @ApiModelProperty("预计使用日期")
    private LocalDate expectDate;
    /**
     * 报销模板id
     */
    @ApiModelProperty("报销模板id")
    private Long reimTmplId;
    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    private Long custId;
    /**
     * 项目非项目
     */
    @ApiModelProperty("项目非项目")
    private String applyType;
    /**
     * 费用码
     */
    @ApiModelProperty("费用码")
    private String feeCode;

    /**
     * 费用承担公司id
     */
    @ApiModelProperty("费用承担公司id")
    private Long ouId;
    /**
     * 费用承担方（类型）
     */
    @ApiModelProperty("费用承担方（类型）")
    private String expenseByType;

    @ApiModelProperty("报销单ID")
    private Long reimId;

    @ApiModelProperty("解绑关联的报销单 0-否 1-是")
    private Integer reimDefaultFlag;
    /**
     * 出差申请详情
     */
    @ApiModelProperty("出差申请详情")
    private List<AdmFeeApplyDetailPayload> detailPayloads;
    /**
     * 删除详情ids
     */
    @ApiModelProperty("删除详情ids")
    private List<Long> delDetailIds;
}
