package com.elitesland.tw.tw5.api.prd.budget.service;

import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetSubjectDetailVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskSettleTimesheetVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 预算公共 接口
 */
public interface BudgetCommonService {


    /**
     * 初始化预算
     *
     * @param sourceId
     * @param sourceType
     */
    BudgetVO initBudget(Long sourceId, String sourceType);

    /**
     * 通过 资源 查询预算
     *
     * @param sourceId
     * @param sourceType
     * @return
     */
    BudgetVO querySimpleBySource(Long sourceId, String sourceType);

    /**
     * 获取 项目、合同 相关信息
     *
     * @param budgetVO
     */
    void addProjectInfo(BudgetVO budgetVO);

    /**
     * 确认当前是否是只有一个流程
     */
    void checkOnlyOneProc(BudgetVO budgetVO);

    /***
     * 判断是否为外部项目
     * @param platType
     * @return
     */
    Boolean isExternalProject(String platType);


    /**
     * 外部无合同提前入场:平台合同类型=提前入场虚拟合同，且子合同状态=待激活
     *
     * @param platType
     * @param contractStatus
     * @return
     */
    Boolean isExternalNoContractProject(String platType, String contractStatus);


    /***
     * 累计变更 相关
     * @param budgetVO
     */
    void countTotalChange(BudgetVO budgetVO);

    /**
     * 累计变更 相关
     *
     * @param currentVersionBudge 当前变更版本预算
     */
    void countCurrentChange(BudgetVO currentVersionBudge);


    /**
     * 根据科目模板id查找预算科目
     *
     * @param subjectTemplateId
     * @return
     */
    List<BudgetSubjectDetailVO> queryBySubjectTemplateId(String sourceType, Long subjectTemplateId);

    /**
     * 查询单个事由和事由类型预算当量、费用使用及占用情况
     *
     * @param commonVO
     * @return
     */
    BudgetCommonVO queryBudgetEqvaAndAmt(BudgetCommonVO commonVO);

    /**
     * 获取当量使用和占用情况
     * 对外暴露的原因是工时审批配置要根据占用比例计算审批人
     *
     * @param commonVO
     * @param taskTimesheetVOS
     */
    void queryBudgetEqva(BudgetCommonVO commonVO, List<TaskSettleTimesheetVO> taskTimesheetVOS);

    /**
     * 查询单个事由和事由类型预算费用使用及占用情况
     *
     * @param commonVO
     * @return
     */
    void queryBudgetAmt(BudgetCommonVO commonVO);

    /**
     * 查询多个事由和事由类型预算当量、费用使用及占用情况
     *
     * @param reasonTypes
     * @param reasonIds
     * @return
     */
    List<BudgetCommonVO> queryBudgetEqvaAndAmts(List<String> reasonTypes, List<Long> reasonIds);

    /**
     * 任务申请时,验证当量是否超出预算
     *
     * @param reasonId
     * @param reasonType
     * @param eqva
     */
    void checkBudgetEqva(Long reasonId, String reasonType, Long relatedActId, BigDecimal eqva);

    /**
     * 校验项目预算费用
     *
     * @param reasonId     事由id
     * @param reasonType   事由类型
     * @param budgetItemId 预算项目id 为了校验科目明细用
     * @param amt          报销金额
     * @param costType     费用类型，更具枚举 BudgetCostType取对应的校验
     * @param sourceId     需要过滤判断的数据主键ID（变更时要把本条数据排除掉）
     */
    void checkBudgetAmt(Long reasonId, String reasonType, Long budgetItemId, BigDecimal amt, String costType, Long... sourceId);

}
