package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;

/**
* 客户经营-企业基本信息
*
* @author duwh
* @date 2022-12-02
*/
@Data
public class CrmCustomerOperationEnterpriseInfoPayload extends TwCommonPayload  {
    /** 客户经营主键 */
    private Long operId;
    /** 启信宝id */
    private String idQxb;
    /** 企业名称（国家公示) */
    private String name;
    private String formatName;
    /** 企业类型 */
    private String econKind;
    /** 企业类型代码 */
    private String econKindCode;
    /** 注册资本（金额数字+1个空格+万+货币单位） */
    private String registCapi;
    private String currencyUnit;
    private String typeNew;
    /** 历史名字 */
    private String historyNamesStr;
    /** 地址 */
    private String address;
    /** 企业注册号 */
    private String regNo;
    /** 经营范围 */
    private String scope;
    /** 营业开始日期 */
    private String termStart;
    /** 营业结束日期 */
    private String termEnd;
    /** 所属工商局 */
    private String belongOrg;
    /** 企业法定代表人 */
    private String operName;
    /** 公司代表人职务 */
    private String title;
    /** 成立日期 */
    private String startDate;
    /** 注销日期 */
    private String endDate;
    /** 核准日期 */
    private String checkDate;
    /** 经营状态（旧字段，不建议使用） */
    private String status;
    private String newStatus;
    /** 组织机构号 */
    private String orgNo;
    /** 统一社会信用代码 */
    private String creditNo;
    /** 地区代码 */
    private String districtCode;
    /** 实缴资本 */
    private String actualCapi;
    /** 企业二级分类 */
    private String categoryNew;
    /** 四级行业 */
    private String domain;
    /** 1-新三板； 6-主板上市公司； 40-暂停上市； 41-终止上市； 9-香港上市； 17-高新企业； */
    private String tagsStr;
    private String revokeReason;
    private String revokeDate;


    /**
     * 1.16 企业简介
     * 企业简介信息
     */
    private String enterpriseDesc;
}
