package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempGradePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempGradeVO;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板等级Service
 */

public interface PrdExamTempGradeService {

    /**
     * 新增绩效考核模板等级数据
     *
     * @param prdExamTempGradePayload
     * @return
     */
    PrdExamTempGradeVO save(PrdExamTempGradePayload prdExamTempGradePayload);

    /**
     * 根据主键更新
     *
     * @param prdExamTempGradePayload
     * @return
     */
    PrdExamTempGradeVO update(PrdExamTempGradePayload prdExamTempGradePayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PrdExamTempGradeVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param prdExamTempGradeQuery
     * @return
     */
    PagingVO<PrdExamTempGradeVO> page(PrdExamTempGradeQuery prdExamTempGradeQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param prdExamTempGradeQuery
     * @return
     */
    List<PrdExamTempGradeVO> getList(PrdExamTempGradeQuery prdExamTempGradeQuery);

    /**
     * 根据条件修改
     *
     * @param prdExamTempGradePayload
     * @return
     */
    Long updateByCondition(PrdExamTempGradePayload prdExamTempGradePayload);

    /**
     * 根据模板id删除
     *
     * @param id
     */
    void delByTempId(Long id);
}

