package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 名片申请
 *
 * @author lemon
 * @date 2023-09-11
 */
@Getter
@Setter
public class TBusiCardApplyQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 英文名 精确 */
    @ApiModelProperty("英文名")
    private String eName;
    /** BaseBU 精确 */
    @ApiModelProperty("BaseBU")
    private Long basebuId;
    /** 所属公司 精确 */
    @ApiModelProperty("所属公司")
    private Long ouId;
    /** 手机号 精确 */
    @ApiModelProperty("手机号")
    private String mobile;
    /** 邮箱 精确 */
    @ApiModelProperty("邮箱")
    private String email;
    /** 中文抬头 精确 */
    @ApiModelProperty("中文抬头")
    private String cTitle;
    /** 英文抬头 精确 */
    @ApiModelProperty("英文抬头")
    private String eTitle;
    /** 邮件标志 精确 */
    @ApiModelProperty("邮件标志")
    private String mailFlag;
    /** 名片邮寄地址 精确 */
    @ApiModelProperty("名片邮寄地址")
    private String mailAddr;
    /** 申请结果 精确 */
    @ApiModelProperty("申请结果")
    private String applyResult;
    /** 取消原因 精确 */
    @ApiModelProperty("取消原因")
    private String cancelReason;
    /** 申请人 精确 */
    @ApiModelProperty("申请人")
    private Long applyResId;
    /** 申请日期 精确 */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /** 流程实例ID 精确 */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 精确 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 精确 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 精确 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}
